/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.pivot.buckets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.AutoValue_TimeUnitInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.DateInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Interval;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonTypeName(value="timeunit")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TimeUnitInterval
implements Interval {
    public static final String type = "timeunit";
    public static final Pattern TIMEUNIT_PATTERN = Pattern.compile("(?<quantity>\\d+)(?<unit>[smhdwMy])");

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty
    public abstract String timeunit();

    @Override
    public DateInterval toDateInterval(TimeRange timerange) {
        return this.adjustUnitsLongerThanDays(this.timeunit());
    }

    private DateInterval adjustUnitsLongerThanDays(String timeunit) {
        String unit;
        Matcher matcher = TIMEUNIT_PATTERN.matcher(this.timeunit());
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Time unit must be {quantity}{unit}, where quantity is a positive number and unit [smhdwMy].");
        int quantity = Integer.parseInt(matcher.group("quantity"));
        switch (unit = matcher.group("unit")) {
            case "s": 
            case "m": 
            case "h": 
            case "d": {
                return new DateInterval(quantity, unit);
            }
            case "w": {
                return quantity == 1 ? new DateInterval(quantity, unit) : DateInterval.days(7 * quantity);
            }
            case "M": {
                return quantity == 1 ? new DateInterval(quantity, unit) : DateInterval.days(30 * quantity);
            }
            case "y": {
                return DateInterval.days(365 * quantity);
            }
        }
        throw new RuntimeException("Invalid time unit: " + timeunit);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="type")
        public abstract Builder type(String var1);

        @JsonProperty(value="timeunit")
        public abstract Builder timeunit(String var1);

        abstract TimeUnitInterval autoBuild();

        public TimeUnitInterval build() {
            TimeUnitInterval interval = this.autoBuild();
            Matcher matcher = TIMEUNIT_PATTERN.matcher(interval.timeunit());
            Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Time unit must be {quantity}{unit}, where quantity is a positive number and unit [smhdwMy].");
            int quantity = Integer.parseInt(matcher.group("quantity"), 10);
            Preconditions.checkArgument((quantity > 0 ? 1 : 0) != 0, (Object)"Time unit's value must be a positive number, greater than zero.");
            return interval;
        }

        @JsonCreator
        public static Builder builder() {
            return new AutoValue_TimeUnitInterval.Builder().type(TimeUnitInterval.type);
        }

        @JsonCreator
        public static Builder createForLegacySingleString(String timeunit) {
            return Builder.builder().timeunit(timeunit);
        }
    }
}

