/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.pivot.buckets;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.ValuesBucketComparator;

public class ValuesBucketOrdering {
    private static boolean isGroupingSort(SortSpec sort) {
        return "pivot".equals(sort.type());
    }

    private static boolean hasGroupingSort(List<SortSpec> sorts) {
        return sorts.stream().anyMatch(ValuesBucketOrdering::isGroupingSort);
    }

    private static boolean needsReordering(List<? extends BucketSpec> bucketSpec, List<SortSpec> sorts) {
        return bucketSpec.size() >= 2 && !sorts.isEmpty() && ValuesBucketOrdering.hasGroupingSort(sorts);
    }

    @VisibleForTesting
    public static <T extends BucketSpec> List<T> orderBuckets(List<T> bucketSpec, List<SortSpec> sorts) {
        if (!ValuesBucketOrdering.needsReordering(bucketSpec, sorts)) {
            return bucketSpec;
        }
        List<String> sortFields = sorts.stream().filter(ValuesBucketOrdering::isGroupingSort).map(SortSpec::field).collect(Collectors.toList());
        return bucketSpec.stream().sorted(new ValuesBucketComparator(sortFields)).collect(Collectors.toList());
    }

    public static Function<List<String>, List<String>> reorderKeysFunction(List<BucketSpec> bucketSpecs, List<SortSpec> sorts) {
        if (!ValuesBucketOrdering.needsReordering(bucketSpecs, sorts)) {
            return Function.identity();
        }
        List<BucketSpec> orderedBuckets = ValuesBucketOrdering.orderBuckets(bucketSpecs, sorts);
        Map mapping = IntStream.range(0, bucketSpecs.size()).boxed().collect(Collectors.toMap(Function.identity(), i -> orderedBuckets.indexOf(bucketSpecs.get((int)i))));
        return keys -> IntStream.range(0, bucketSpecs.size()).boxed().map(i -> (String)keys.get((Integer)mapping.get(i))).collect(Collectors.toList());
    }
}

