/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.validation.FieldTypeValidation;
import org.graylog.plugins.views.search.validation.ImmutableToken;
import org.graylog.plugins.views.search.validation.ParsedTerm;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.plugin.Tools;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class FieldTypeValidationImpl
implements FieldTypeValidation {
    private static final List<DateTimeFormatter> DATE_TIME_FORMATTERS = ImmutableList.of((Object)Tools.ISO_DATE_FORMAT_FORMATTER, (Object)Tools.ES_DATE_FORMAT_FORMATTER, (Object)Tools.ES_DATE_FORMAT_NO_MS_FORMATTER, (Object)ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    private static final List<String> NUMERIC_OPERANDS = ImmutableList.of((Object)">=", (Object)"<=", (Object)">", (Object)"<").stream().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
    private static final Map<String, Predicate<String>> VALIDATION_FUNCTIONS = new HashMap<String, Predicate<String>>();
    private static final Predicate<String> ALWAYS_TRUE_PREDICATE = value -> true;

    private static Function<String, Object> removeNumericOperandsIfNeeded(Function<String, Object> numericParser) {
        return value -> {
            Optional<String> operand = NUMERIC_OPERANDS.stream().filter(value::startsWith).findFirst();
            if (operand.isPresent()) {
                return numericParser.apply(value.substring(operand.get().length()));
            }
            return numericParser.apply((String)value);
        };
    }

    private static boolean isDate(String dateCandidate) {
        for (DateTimeFormatter formatter : DATE_TIME_FORMATTERS) {
            try {
                formatter.parseDateTime(dateCandidate);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private static boolean isValidIp(String ip) {
        try {
            return InetAddressValidator.getInstance().isValid(ip) || FieldTypeValidationImpl.isValidCidrIp(ip);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isValidCidrIp(String cidrIp) {
        try {
            new SubnetUtils(cidrIp);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Predicate<String> wrapException(Function<String, Object> parser) {
        return value -> {
            try {
                parser.apply((String)value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    @Override
    public Optional<ValidationMessage> validateFieldValueType(ParsedTerm term, String detectedFieldType) {
        if (!this.typeMatching(detectedFieldType, term.value())) {
            ValidationMessage.Builder builder = ValidationMessage.builder(ValidationStatus.WARNING, ValidationType.INVALID_VALUE_TYPE).errorMessage(String.format(Locale.ROOT, "Type of %s is %s, cannot use value %s", term.getRealFieldName(), detectedFieldType, term.value()));
            Optional<ImmutableToken> tokenWithPositions = term.valueToken().isPresent() ? term.valueToken() : term.keyToken();
            tokenWithPositions.map(QueryPosition::from).ifPresent(builder::position);
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private boolean typeMatching(String type, String value) {
        return Optional.ofNullable(type).map(VALIDATION_FUNCTIONS::get).map(validator -> validator.test(value)).orElse(true);
    }

    static {
        VALIDATION_FUNCTIONS.put("string", ALWAYS_TRUE_PREDICATE);
        VALIDATION_FUNCTIONS.put("long", FieldTypeValidationImpl.wrapException(FieldTypeValidationImpl.removeNumericOperandsIfNeeded(Long::parseLong)));
        VALIDATION_FUNCTIONS.put("int", FieldTypeValidationImpl.wrapException(FieldTypeValidationImpl.removeNumericOperandsIfNeeded(Integer::parseInt)));
        VALIDATION_FUNCTIONS.put("short", FieldTypeValidationImpl.wrapException(FieldTypeValidationImpl.removeNumericOperandsIfNeeded(Short::parseShort)));
        VALIDATION_FUNCTIONS.put("byte", FieldTypeValidationImpl.wrapException(FieldTypeValidationImpl.removeNumericOperandsIfNeeded(Byte::parseByte)));
        VALIDATION_FUNCTIONS.put("double", FieldTypeValidationImpl.wrapException(FieldTypeValidationImpl.removeNumericOperandsIfNeeded(Double::parseDouble)));
        VALIDATION_FUNCTIONS.put("float", FieldTypeValidationImpl.wrapException(FieldTypeValidationImpl.removeNumericOperandsIfNeeded(Float::parseFloat)));
        VALIDATION_FUNCTIONS.put("date", FieldTypeValidationImpl::isDate);
        VALIDATION_FUNCTIONS.put("boolean", FieldTypeValidationImpl.wrapException(Boolean::parseBoolean));
        VALIDATION_FUNCTIONS.put("binary", ALWAYS_TRUE_PREDICATE);
        VALIDATION_FUNCTIONS.put("geo-point", ALWAYS_TRUE_PREDICATE);
        VALIDATION_FUNCTIONS.put("ip", FieldTypeValidationImpl::isValidIp);
    }
}

