/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.AllPermission;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.graylog.grn.GRN;
import org.graylog.security.UserContextMissingException;
import org.graylog.security.permissions.GRNPermission;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;

public class UserContext {
    private final UserService userService;
    private final String userId;
    private final Subject subject;

    public static <T> T runAs(String username, Callable<T> callable) {
        Subject subject = new Subject.Builder().principals((PrincipalCollection)new SimplePrincipalCollection((Object)username, "runAs-context")).authenticated(true).sessionCreationEnabled(false).buildSubject();
        return (T)subject.execute(callable);
    }

    public static void runAs(String username, Runnable runnable) {
        Subject subject = new Subject.Builder().principals((PrincipalCollection)new SimplePrincipalCollection((Object)username, "runAs-context")).authenticated(true).sessionCreationEnabled(false).buildSubject();
        subject.execute(runnable);
    }

    public UserContext(String userId, Subject subject, UserService userService) {
        this.userId = userId;
        this.subject = subject;
        this.userService = userService;
    }

    public String getUserId() {
        return this.userId;
    }

    public User getUser() {
        return Optional.ofNullable(this.userService.loadById(this.userId)).orElseThrow(() -> new IllegalStateException("Cannot load user <" + this.userId + "> from db"));
    }

    protected boolean isOwner(GRN entity) {
        return this.subject.isPermitted((Permission)GRNPermission.create("entity:own", entity));
    }

    public boolean hasAllPermission() {
        return this.subject.isPermitted((Permission)new AllPermission());
    }

    public boolean isPermitted(String permission, GRN target) {
        return this.isPermitted(permission, target.entity());
    }

    public boolean isPermitted(String permission, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)permission), (Object)"permission cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id cannot be null or empty");
        return this.subject.isPermitted(permission + ":" + id);
    }

    public boolean isPermitted(String permission) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)permission), (Object)"permission cannot be null or empty");
        return this.subject.isPermitted(permission);
    }

    public static class Factory {
        private final UserService userService;

        @Inject
        public Factory(UserService userService) {
            this.userService = userService;
        }

        public UserContext create() throws UserContextMissingException {
            try {
                Subject subject = SecurityUtils.getSubject();
                Object userId = subject.getPrincipal();
                if (!(userId instanceof String)) {
                    throw new UserContextMissingException("Unknown SecurityContext class <" + userId + ">, cannot continue.");
                }
                return new UserContext((String)userId, subject, this.userService);
            }
            catch (IllegalStateException | UnavailableSecurityManagerException e) {
                throw new UserContextMissingException("Cannot retrieve current subject, SecurityContext isn't set.");
            }
        }

        public UserContext create(Subject subject) {
            return new UserContext((String)subject.getPrincipal(), subject, this.userService);
        }
    }
}

