/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.graylog.grn.GRN;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog.security.shares.Grantee;

final class AutoValue_EntityDescriptor
extends EntityDescriptor {
    private final GRN id;
    private final String title;
    private final ImmutableSet<Grantee> owners;

    private AutoValue_EntityDescriptor(GRN id, String title, ImmutableSet<Grantee> owners) {
        this.id = id;
        this.title = title;
        this.owners = owners;
    }

    @Override
    @JsonProperty(value="id")
    public GRN id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="owners")
    public ImmutableSet<Grantee> owners() {
        return this.owners;
    }

    public String toString() {
        return "EntityDescriptor{id=" + this.id + ", title=" + this.title + ", owners=" + this.owners + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityDescriptor) {
            EntityDescriptor that = (EntityDescriptor)o;
            return this.id.equals(that.id()) && this.title.equals(that.title()) && this.owners.equals(that.owners());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        return h$ ^= this.owners.hashCode();
    }

    @Override
    public EntityDescriptor.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EntityDescriptor.Builder {
        private GRN id;
        private String title;
        private ImmutableSet<Grantee> owners;

        Builder() {
        }

        private Builder(EntityDescriptor source) {
            this.id = source.id();
            this.title = source.title();
            this.owners = source.owners();
        }

        @Override
        public EntityDescriptor.Builder id(GRN id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public EntityDescriptor.Builder title(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public EntityDescriptor.Builder owners(Set<Grantee> owners) {
            this.owners = ImmutableSet.copyOf(owners);
            return this;
        }

        @Override
        public EntityDescriptor build() {
            Object missing = "";
            if (this.id == null) {
                missing = (String)missing + " id";
            }
            if (this.title == null) {
                missing = (String)missing + " title";
            }
            if (this.owners == null) {
                missing = (String)missing + " owners";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_EntityDescriptor(this.id, this.title, this.owners);
        }
    }
}

