/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.GraylogVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.Version;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.graylog2.system.urlwhitelist.WhitelistEntry;

public class UrlWhitelistFacade
implements EntityFacade<WhitelistEntry> {
    public static final ModelType TYPE_V1 = ModelTypes.URL_WHITELIST_ENTRY_V1;
    private final ObjectMapper objectMapper;
    private final UrlWhitelistService urlWhitelistService;

    @Inject
    public UrlWhitelistFacade(ObjectMapper objectMapper, UrlWhitelistService urlWhitelistService) {
        this.objectMapper = objectMapper;
        this.urlWhitelistService = urlWhitelistService;
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        return this.urlWhitelistService.getEntry(modelId.id()).map(entry -> ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(entry.id(), ModelTypes.URL_WHITELIST_ENTRY_V1)))).type(ModelTypes.URL_WHITELIST_ENTRY_V1)).data((JsonNode)this.objectMapper.convertValue(entry, JsonNode.class)).constraints((ImmutableSet<Constraint>)ImmutableSet.of((Object)GraylogVersionConstraint.of(Version.from(3, 1, 3)))).build());
    }

    @Override
    public NativeEntity<WhitelistEntry> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (!(entity instanceof EntityV1)) {
            throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
        }
        WhitelistEntry whitelistEntry = (WhitelistEntry)this.objectMapper.convertValue((Object)((EntityV1)entity).data(), WhitelistEntry.class);
        this.urlWhitelistService.addEntry(whitelistEntry);
        return NativeEntity.create(entity.id(), whitelistEntry.id(), TYPE_V1, this.createTitle(whitelistEntry), whitelistEntry);
    }

    @Override
    public Optional<NativeEntity<WhitelistEntry>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        ModelId modelId = nativeEntityDescriptor.id();
        return this.urlWhitelistService.getEntry(modelId.id()).map(entry -> NativeEntity.create(nativeEntityDescriptor, entry));
    }

    @Override
    public void delete(WhitelistEntry nativeEntity) {
        this.urlWhitelistService.removeEntry(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(WhitelistEntry whitelistEntry) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(whitelistEntry.id()))).type(ModelTypes.URL_WHITELIST_ENTRY_V1)).title(this.createTitle(whitelistEntry)).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.urlWhitelistService.getWhitelist().entries().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    private String createTitle(WhitelistEntry entry) {
        return entry.title() + " [" + entry.value() + "]";
    }
}

