/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedDbService;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.lookup.events.LookupTablesDeleted;
import org.graylog2.lookup.events.LookupTablesUpdated;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class DBLookupTableService
extends ScopedDbService<LookupTableDto> {
    public static final String COLLECTION_NAME = "lut_tables";
    private final ClusterEventBus clusterEventBus;

    @Inject
    public DBLookupTableService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EntityScopeService entityScopeService, ClusterEventBus clusterEventBus) {
        super(mongoConnection, mapper, LookupTableDto.class, COLLECTION_NAME, entityScopeService);
        this.clusterEventBus = clusterEventBus;
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public Optional<LookupTableDto> get(String idOrName) {
        if (ObjectId.isValid((String)idOrName)) {
            return Optional.ofNullable((LookupTableDto)this.db.findOneById((Object)new ObjectId(idOrName)));
        }
        return Optional.ofNullable((LookupTableDto)this.db.findOne(DBQuery.is((String)"name", (Object)idOrName)));
    }

    public LookupTableDto saveAndPostEvent(LookupTableDto table) {
        LookupTableDto savedLookupTable = super.save(table);
        this.clusterEventBus.post(LookupTablesUpdated.create(savedLookupTable));
        return savedLookupTable;
    }

    public Collection<LookupTableDto> findAll() {
        return this.asImmutableList(this.db.find());
    }

    public PaginatedList<LookupTableDto> findPaginated(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        try (DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            PaginatedList<LookupTableDto> paginatedList = new PaginatedList<LookupTableDto>((List<LookupTableDto>)this.asImmutableList(cursor), cursor.count(), page, perPage);
            return paginatedList;
        }
    }

    public Collection<LookupTableDto> findByCacheIds(Collection<String> cacheIds) {
        DBQuery.Query query = DBQuery.in((String)"cache", (Collection)cacheIds.stream().map(ObjectId::new).collect(Collectors.toList()));
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList immutableList = this.asImmutableList(cursor);
            return immutableList;
        }
    }

    public Collection<LookupTableDto> findByDataAdapterIds(Collection<String> dataAdapterIds) {
        DBQuery.Query query = DBQuery.in((String)"data_adapter", (Collection)dataAdapterIds.stream().map(ObjectId::new).collect(Collectors.toList()));
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList immutableList = this.asImmutableList(cursor);
            return immutableList;
        }
    }

    public void deleteAndPostEvent(String idOrName) {
        Optional<LookupTableDto> lookupTableDto = this.get(idOrName);
        super.delete(idOrName);
        lookupTableDto.ifPresent(lookupTable -> this.clusterEventBus.post(LookupTablesDeleted.create(lookupTable)));
    }

    public void deleteAndPostEventImmutable(String idOrName) {
        Optional<LookupTableDto> lookupTableDto = this.get(idOrName);
        super.deleteImmutable(idOrName);
        lookupTableDto.ifPresent(lookupTable -> this.clusterEventBus.post(LookupTablesDeleted.create(lookupTable)));
    }

    public void forEach(Consumer<? super LookupTableDto> action) {
        try (DBCursor dbCursor = this.db.find();){
            dbCursor.forEachRemaining(action);
        }
    }
}

