/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.cluster.Node;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.migrations.Migration;
import org.graylog2.storage.SearchVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20170607164210_MigrateReopenedIndicesToAliases
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20170607164210_MigrateReopenedIndicesToAliases.class);
    private static final String REOPENED_INDEX_SETTING = "graylog2_reopened";
    private final Node node;
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final Indices indices;
    private final ClusterState clusterState;

    @Inject
    public V20170607164210_MigrateReopenedIndicesToAliases(Node node, IndexSetService indexSetService, MongoIndexSet.Factory mongoIndexSetFactory, Indices indices, ClusterState clusterState) {
        this.node = node;
        this.indexSetService = indexSetService;
        this.mongoIndexSetFactory = mongoIndexSetFactory;
        this.indices = indices;
        this.clusterState = clusterState;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2017-06-07T16:42:10Z");
    }

    @Override
    public void upgrade() {
        this.indexSetService.findAll().stream().map(this.mongoIndexSetFactory::create).flatMap(indexSet -> this.getReopenedIndices((IndexSet)indexSet).stream()).peek(indexName -> LOG.debug("Marking index {} to be reopened using alias.", indexName)).forEach(this.indices::markIndexReopened);
    }

    private Set<String> getReopenedIndices(Collection<String> indices) {
        SearchVersion elasticsearchVersion = this.node.getVersion().orElseThrow(() -> new ElasticsearchException("Unable to retrieve Elasticsearch version."));
        JsonNode clusterStateJson = this.clusterState.getForIndices(indices);
        JsonNode indicesJson = clusterStateJson.path("metadata").path("indices");
        ImmutableSet.Builder reopenedIndices = ImmutableSet.builder();
        if (indicesJson.isMissingNode()) {
            LOG.error("Retrieved cluster state is invalid (no metadata.indices key).");
            LOG.debug("Received cluster state was: {}", (Object)clusterStateJson.toString());
            return Collections.emptySet();
        }
        Iterator it = indicesJson.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            JsonNode indexSettings = value.path("settings");
            if (indexSettings.isMissingNode()) {
                LOG.error("Unable to retrieve index settings from metadata for index {} - skipping.", (Object)indexName);
                LOG.debug("Index metadata was: {}", (Object)value.toString());
                continue;
            }
            if (!this.checkForReopened(indexSettings, elasticsearchVersion)) continue;
            LOG.debug("Adding {} to list of indices to be migrated.", (Object)indexName);
            reopenedIndices.add((Object)indexName);
        }
        return reopenedIndices.build();
    }

    private boolean checkForReopened(@Nonnull JsonNode indexSettings, SearchVersion searchVersion) {
        JsonNode settings;
        if (searchVersion.satisfies(SearchVersion.Distribution.ELASTICSEARCH, ">=2.1.0 & <5.0.0")) {
            settings = indexSettings;
        } else if (searchVersion.satisfies(SearchVersion.Distribution.ELASTICSEARCH, "^5.0.0 | ^6.0.0 | ^7.0.0") || searchVersion.satisfies(SearchVersion.Distribution.OPENSEARCH, "^1.0.0 | ^2.0.0")) {
            settings = indexSettings.path("archived");
        } else {
            throw new ElasticsearchException("Unsupported search version: " + searchVersion);
        }
        return settings.path("index").path(REOPENED_INDEX_SETTING).asBoolean();
    }

    private Set<String> getReopenedIndices(IndexSet indexSet) {
        return this.getReopenedIndices(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public static interface ClusterState {
        public JsonNode getForIndices(Collection<String> var1);
    }
}

