/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.DateValidator;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.FilledStringValidator;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.OptionalStringValidator;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.WidgetPosition;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

class MigrationDashboard {
    static final String FIELD_ID = "_id";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_CONTENT_PACK = "content_pack";
    private static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String EMBEDDED_POSITIONS = "positions";
    private final Map<String, Object> fields;
    private final ObjectId id;
    private final AtomicReference<String> hexId = new AtomicReference<Object>(null);

    MigrationDashboard(ObjectId id, @Nullable Map<String, Object> fields) {
        this.id = id;
        if (null != this.id) {
            this.hexId.set(this.id.toHexString());
        }
        if (fields == null) {
            this.fields = new HashMap<String, Object>();
        } else {
            this.fields = new HashMap<String, Object>(fields.size());
            for (Map.Entry<String, Object> field : fields.entrySet()) {
                String key = field.getKey();
                Object value = field.getValue();
                if (value instanceof Date) {
                    this.fields.put(key, new DateTime(value, DateTimeZone.UTC));
                    continue;
                }
                this.fields.put(key, value);
            }
        }
    }

    String getTitle() {
        return (String)this.fields.get(FIELD_TITLE);
    }

    List<WidgetPosition> getPositions() {
        BasicDBObject positions = (BasicDBObject)this.fields.get(EMBEDDED_POSITIONS);
        if (positions == null) {
            return Collections.emptyList();
        }
        ArrayList<WidgetPosition> result = new ArrayList<WidgetPosition>(positions.size());
        for (String positionId : positions.keySet()) {
            BasicDBObject position = (BasicDBObject)positions.get(positionId);
            int width = Integer.parseInt(position.getString("width", "1"));
            int height = Integer.parseInt(position.getString("height", "1"));
            int col = Integer.parseInt(position.getString("col", "1"));
            int row = Integer.parseInt(position.getString("row", "1"));
            WidgetPosition widgetPosition = WidgetPosition.builder().id(positionId).width(width).height(height).col(col).row(row).build();
            result.add(widgetPosition);
        }
        return result;
    }

    void setPositions(List<WidgetPosition> widgetPositions) {
        Preconditions.checkNotNull(widgetPositions, (Object)"widgetPositions must be given");
        HashMap positions = new HashMap(widgetPositions.size());
        for (WidgetPosition widgetPosition : widgetPositions) {
            HashMap<String, Integer> position = new HashMap<String, Integer>(4);
            position.put("width", widgetPosition.width());
            position.put("height", widgetPosition.height());
            position.put("col", widgetPosition.col());
            position.put("row", widgetPosition.row());
            positions.put(widgetPosition.id(), position);
        }
        Map<String, Object> fields = this.getFields();
        Preconditions.checkNotNull(fields, (Object)"No fields found!");
        fields.put(EMBEDDED_POSITIONS, positions);
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    Map<String, Validator> getValidations() {
        return ImmutableMap.builder().put((Object)FIELD_TITLE, (Object)new FilledStringValidator()).put((Object)FIELD_DESCRIPTION, (Object)new FilledStringValidator()).put((Object)FIELD_CONTENT_PACK, (Object)new OptionalStringValidator()).put((Object)FIELD_CREATOR_USER_ID, (Object)new FilledStringValidator()).put((Object)FIELD_CREATED_AT, (Object)new DateValidator()).build();
    }

    String getId() {
        String s = this.hexId.get();
        if (s == null && this.id != null) {
            String hexString = this.getObjectId().toHexString();
            this.hexId.compareAndSet(null, hexString);
            return hexString;
        }
        return s;
    }

    private ObjectId getObjectId() {
        return this.id;
    }
}

