/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import one.util.streamex.EntryStream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220929145442_MigratePivotLimitsInViews
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20220929145442_MigratePivotLimitsInViews.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> views;

    @Inject
    public V20220929145442_MigratePivotLimitsInViews(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.views = mongoConnection.getMongoDatabase().getCollection("views");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-09-29T14:56:42Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        ArrayList widgetLimitMigrations = new ArrayList();
        for (Document document : this.views.find()) {
            String viewId = ((ObjectId)document.get((Object)"_id", ObjectId.class)).toHexString();
            Map state = (Map)document.get((Object)"state", Collections.emptyMap());
            state.entrySet().stream().forEach(entry -> {
                String queryId = (String)entry.getKey();
                List widgets = (List)((Document)entry.getValue()).get((Object)"widgets", Collections.emptyList());
                ((EntryStream)EntryStream.of((List)widgets).filter(widget -> "aggregation".equals(((Document)widget.getValue()).getString((Object)"type")))).forEach(widgetEntry -> {
                    Document widget = (Document)widgetEntry.getValue();
                    Integer widgetIndex = (Integer)widgetEntry.getKey();
                    Optional<Document> optionalConfig = Optional.ofNullable((Document)widget.get((Object)"config", Document.class));
                    optionalConfig.ifPresent(config -> {
                        List rowPivots = (List)config.get((Object)"row_pivots", Collections.emptyList());
                        Optional<Integer> maxRowPivotLimit = this.extractMaxLimit(rowPivots);
                        List columnPivots = (List)config.get((Object)"column_pivots", Collections.emptyList());
                        Optional<Integer> maxColumnPivotLimit = this.extractMaxLimit(columnPivots);
                        if (widgetIndex != null && (maxRowPivotLimit.isPresent() || maxColumnPivotLimit.isPresent())) {
                            widgetLimitMigrations.add(new ViewWidgetLimitMigration(viewId, queryId, widgetIndex, maxRowPivotLimit, maxColumnPivotLimit));
                        }
                    });
                });
            });
        }
        List operations = widgetLimitMigrations.stream().flatMap(widgetMigration -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            widgetMigration.rowLimit().ifPresent(rowLimit -> {
                builder.add(this.updateView(widgetMigration.viewId, new Document("$set", (Object)new Document(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".row_limit", rowLimit))));
                builder.add(this.updateView(widgetMigration.viewId, new Document("$unset", (Object)new Document(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".row_pivots.$[].config.limit", (Object)1))));
            });
            widgetMigration.columnLimit().ifPresent(columnLimit -> {
                builder.add(this.updateView(widgetMigration.viewId, new Document("$set", (Object)new Document(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".column_limit", columnLimit))));
                builder.add(this.updateView(widgetMigration.viewId, new Document("$unset", (Object)new Document(this.widgetConfigPath((ViewWidgetLimitMigration)widgetMigration) + ".column_pivots.$[].config.limit", (Object)1))));
            });
            return builder.build().stream();
        }).collect(Collectors.toList());
        if (!operations.isEmpty()) {
            this.views.bulkWrite(operations);
        }
        this.clusterConfigService.write(new MigrationCompleted(widgetLimitMigrations.size()));
    }

    private String widgetConfigPath(ViewWidgetLimitMigration widgetMigration) {
        return "state." + widgetMigration.queryId() + ".widgets." + widgetMigration.widgetIndex() + ".config";
    }

    private WriteModel<Document> updateView(String viewId, Document update) {
        return new UpdateOneModel((Bson)new Document("_id", (Object)new ObjectId(viewId)), (Bson)update, new UpdateOptions().upsert(false));
    }

    private Optional<Integer> extractMaxLimit(List<Document> pivots) {
        return pivots.stream().filter(pivot -> "values".equals(pivot.get((Object)"type"))).map(pivot -> (Document)pivot.get((Object)"config", Document.class)).map(pivotConfig -> pivotConfig != null ? pivotConfig.getInteger((Object)"limit") : null).filter(Objects::nonNull).max(Integer::compare);
    }

    public record MigrationCompleted(@JsonProperty(value="migrated_widgets") Integer migratedViews) {
    }

    public record ViewWidgetLimitMigration(String viewId, String queryId, Integer widgetIndex, Optional<Integer> rowLimit, Optional<Integer> columnLimit) {
    }
}

