/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.AllPermission;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.graylog.security.permissions.CaseSensitiveWildcardPermission;
import org.graylog2.shared.users.Role;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InMemoryRolePermissionResolver
implements RolePermissionResolver {
    private static final Logger log = LoggerFactory.getLogger(InMemoryRolePermissionResolver.class);
    private final RoleService roleService;
    private final AtomicReference<ImmutableMap<String, Role>> idToRoleIndex = new AtomicReference<ImmutableMap>(ImmutableMap.of());

    @Inject
    public InMemoryRolePermissionResolver(RoleService roleService, @Named(value="daemonScheduler") ScheduledExecutorService daemonScheduler) {
        this.roleService = roleService;
        RoleUpdater updater = new RoleUpdater();
        updater.run();
        daemonScheduler.scheduleAtFixedRate(updater, 1L, 1L, TimeUnit.SECONDS);
    }

    public Collection<Permission> resolvePermissionsInRole(String roleId) {
        Set<String> permissions = this.resolveStringPermission(roleId);
        return permissions.stream().map(p -> {
            if (p.equals("*")) {
                return new AllPermission();
            }
            return new CaseSensitiveWildcardPermission((String)p);
        }).collect(Collectors.toList());
    }

    @Nonnull
    public Set<String> resolveStringPermission(String roleId) {
        ImmutableMap<String, Role> index = this.idToRoleIndex.get();
        Role role = (Role)index.get((Object)roleId);
        if (role == null) {
            log.debug("Unknown role {}, cannot resolve permissions.", (Object)roleId);
            return Collections.emptySet();
        }
        Set<String> permissions = role.getPermissions();
        if (permissions == null) {
            log.debug("Role {} has no permissions assigned, cannot resolve permissions.", (Object)roleId);
            return Collections.emptySet();
        }
        return permissions;
    }

    private class RoleUpdater
    implements Runnable {
        private RoleUpdater() {
        }

        @Override
        public void run() {
            try {
                Map<String, Role> index = InMemoryRolePermissionResolver.this.roleService.loadAllIdMap();
                InMemoryRolePermissionResolver.this.idToRoleIndex.set((ImmutableMap<String, Role>)ImmutableMap.copyOf(index));
            }
            catch (Exception e) {
                log.error("Could not find roles collection, no user roles updated.", (Throwable)e);
            }
        }
    }
}

