/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

public class EmbeddingControlFilter
implements ContainerResponseFilter {
    private static final String X_FRAME_OPTIONS = "X-Frame-Options";
    private final boolean httpAllowEmbedding;

    @Inject
    public EmbeddingControlFilter(@Named(value="http_allow_embedding") boolean httpAllowEmbedding) {
        this.httpAllowEmbedding = httpAllowEmbedding;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        responseContext.getHeaders().add((Object)X_FRAME_OPTIONS, (Object)(this.httpAllowEmbedding ? EmbeddingOptions.SAMEORIGIN : EmbeddingOptions.DENY).toString());
    }

    static enum EmbeddingOptions {
        DENY,
        SAMEORIGIN;

    }
}

