/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamMetrics;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFaultManager {
    private static final Logger LOG = LoggerFactory.getLogger(StreamFaultManager.class);
    private final StreamMetrics streamMetrics;
    private final NotificationService notificationService;
    private final StreamService streamService;
    private final int maxFaultCount;
    private final long streamProcessingTimeout;
    private final ConcurrentMap<String, AtomicInteger> faultCounter = Maps.newConcurrentMap();

    @Inject
    public StreamFaultManager(Configuration configuration, StreamMetrics streamMetrics, NotificationService notificationService, StreamService streamService) {
        this.streamMetrics = streamMetrics;
        this.notificationService = notificationService;
        this.streamService = streamService;
        this.maxFaultCount = configuration.getStreamProcessingMaxFaults();
        this.streamProcessingTimeout = configuration.getStreamProcessingTimeout();
    }

    public long getStreamProcessingTimeout() {
        return this.streamProcessingTimeout;
    }

    public void registerFailure(Stream stream) {
        AtomicInteger faultCount = this.getFaultCount(stream);
        int streamFaultCount = faultCount.incrementAndGet();
        this.streamMetrics.markStreamRuleTimeout(stream.getId());
        if (this.maxFaultCount > 0 && streamFaultCount >= this.maxFaultCount) {
            try {
                this.streamService.pause(stream);
                faultCount.set(0);
                this.streamMetrics.markStreamFaultsExceeded(stream.getId());
                LOG.error("Processing of stream <{}> failed to return within {}ms for more than {} times. Disabling stream.", new Object[]{stream.getId(), this.streamProcessingTimeout, this.maxFaultCount});
                this.triggerNotification(stream, streamFaultCount);
            }
            catch (ValidationException ex) {
                LOG.error("Unable to pause stream: {}", (Throwable)ex);
            }
        } else {
            LOG.warn("Processing of stream <{}> failed to return within {}ms.", (Object)stream.getId(), (Object)this.streamProcessingTimeout);
        }
    }

    private void triggerNotification(Stream stream, int streamFaultCount) {
        Notification notification = this.notificationService.buildNow().addType(Notification.Type.STREAM_PROCESSING_DISABLED).addSeverity(Notification.Severity.URGENT).addDetail("stream_id", stream.getId()).addDetail("stream_title", stream.getTitle()).addDetail("fault_count", streamFaultCount);
        this.notificationService.publishIfFirst(notification);
    }

    private AtomicInteger getFaultCount(Stream stream) {
        this.faultCounter.putIfAbsent(stream.getId(), new AtomicInteger());
        return (AtomicInteger)this.faultCounter.get(stream.getId());
    }
}

