/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.v9;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.graylog.plugins.netflow.v9.NetFlowV9FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetFlowV9FieldTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(NetFlowV9FieldTypeRegistry.class);
    private static final String DEFAULT_DEFINITIONS = "/netflow9.yml";
    private final Map<Integer, NetFlowV9FieldType> fieldTypes;

    private NetFlowV9FieldTypeRegistry(InputStream definitions) throws IOException {
        this(definitions, new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    private NetFlowV9FieldTypeRegistry(InputStream definitions, ObjectMapper yamlMapper) throws IOException {
        try {
            this.fieldTypes = NetFlowV9FieldTypeRegistry.parseYaml(definitions, yamlMapper);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse NetFlow 9 definitions", e);
        }
    }

    public static NetFlowV9FieldTypeRegistry create() throws IOException {
        URL url = Resources.getResource(NetFlowV9FieldTypeRegistry.class, (String)DEFAULT_DEFINITIONS);
        try (InputStream inputStream = url.openStream();){
            NetFlowV9FieldTypeRegistry netFlowV9FieldTypeRegistry = new NetFlowV9FieldTypeRegistry(inputStream);
            return netFlowV9FieldTypeRegistry;
        }
    }

    public static NetFlowV9FieldTypeRegistry create(InputStream definitions) throws IOException {
        return new NetFlowV9FieldTypeRegistry(definitions);
    }

    private static Map<Integer, NetFlowV9FieldType> parseYaml(InputStream inputStream, ObjectMapper yamlMapper) throws IOException {
        JsonNode node = (JsonNode)yamlMapper.readValue(inputStream, JsonNode.class);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            NetFlowV9FieldType.ValueType type;
            Integer id;
            Map.Entry field = (Map.Entry)fields.next();
            try {
                id = Integer.parseInt((String)field.getKey());
            }
            catch (NumberFormatException e) {
                LOG.debug("Skipping record with invalid id: {}", field.getKey(), (Object)e);
                continue;
            }
            JsonNode value = (JsonNode)field.getValue();
            if (!value.isArray()) {
                LOG.debug("Skipping invalid record: {}", (Object)field);
                continue;
            }
            if (value.size() == 1 && ":skip".equals(value.get(0).asText())) {
                LOG.debug("Skipping record: {}", (Object)field);
                continue;
            }
            if (value.size() != 2) {
                LOG.debug("Skipping incomplete record: {}", (Object)field);
                continue;
            }
            JsonNode typeNode = value.get(0);
            if (typeNode.isTextual()) {
                type = NetFlowV9FieldTypeRegistry.symbolToValueType(typeNode.asText());
            } else if (typeNode.isInt()) {
                type = NetFlowV9FieldTypeRegistry.intToValueType(typeNode.asInt());
            } else {
                LOG.debug("Skipping invalid record type: {}", (Object)field);
                continue;
            }
            JsonNode nameNode = value.get(1);
            if (!nameNode.isTextual()) {
                LOG.debug("Skipping invalid record type: {}", (Object)field);
                continue;
            }
            String symbol = nameNode.asText();
            String name = NetFlowV9FieldTypeRegistry.rubySymbolToString(symbol);
            mapBuilder.put((Object)id, (Object)NetFlowV9FieldType.create(id, type, name));
        }
        return mapBuilder.build();
    }

    private static String rubySymbolToString(String symbol) {
        if (symbol.charAt(0) == ':') {
            return symbol.substring(1);
        }
        return symbol;
    }

    private static NetFlowV9FieldType.ValueType symbolToValueType(String type) {
        switch (type) {
            case ":int8": {
                return NetFlowV9FieldType.ValueType.INT8;
            }
            case ":uint8": {
                return NetFlowV9FieldType.ValueType.UINT8;
            }
            case ":int16": {
                return NetFlowV9FieldType.ValueType.INT16;
            }
            case ":uint16": {
                return NetFlowV9FieldType.ValueType.UINT16;
            }
            case ":int24": {
                return NetFlowV9FieldType.ValueType.INT24;
            }
            case ":uint24": {
                return NetFlowV9FieldType.ValueType.UINT24;
            }
            case ":int32": {
                return NetFlowV9FieldType.ValueType.INT32;
            }
            case ":uint32": {
                return NetFlowV9FieldType.ValueType.UINT32;
            }
            case ":int64": {
                return NetFlowV9FieldType.ValueType.INT64;
            }
            case ":uint64": {
                return NetFlowV9FieldType.ValueType.UINT64;
            }
            case ":ip4_addr": {
                return NetFlowV9FieldType.ValueType.IPV4;
            }
            case ":ip6_addr": {
                return NetFlowV9FieldType.ValueType.IPV6;
            }
            case ":mac_addr": {
                return NetFlowV9FieldType.ValueType.MAC;
            }
            case ":string": {
                return NetFlowV9FieldType.ValueType.STRING;
            }
            case ":forwarding_status": {
                return NetFlowV9FieldType.ValueType.UINT8;
            }
            case "mpls_label_stack_octets": {
                return NetFlowV9FieldType.ValueType.UINT32;
            }
        }
        LOG.debug("Unknown type: {}", (Object)type);
        return NetFlowV9FieldType.ValueType.STRING;
    }

    private static NetFlowV9FieldType.ValueType intToValueType(int length) {
        switch (length) {
            case 1: {
                return NetFlowV9FieldType.ValueType.UINT8;
            }
            case 2: {
                return NetFlowV9FieldType.ValueType.UINT16;
            }
            case 3: {
                return NetFlowV9FieldType.ValueType.UINT24;
            }
            case 4: {
                return NetFlowV9FieldType.ValueType.UINT32;
            }
            case 8: {
                return NetFlowV9FieldType.ValueType.UINT64;
            }
        }
        LOG.debug("Unknown type length: " + length);
        return NetFlowV9FieldType.ValueType.STRING;
    }

    public NetFlowV9FieldType get(int id) {
        return this.fieldTypes.get(id);
    }

    public Map<Integer, NetFlowV9FieldType> asMap() {
        return this.fieldTypes;
    }
}

