/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.views.;
import org.graylog.plugins.views.search.views.DisplayModeSettings;
import org.graylog.plugins.views.search.views.FormattingSettings;
import org.graylog.plugins.views.search.views.Titles;
import org.graylog.plugins.views.search.views.WidgetDTO;
import org.graylog.plugins.views.search.views.WidgetPositionDTO;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.ViewStateEntity;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ViewStateDTO
implements ContentPackable<ViewStateEntity> {
    static final String FIELD_SELECTED_FIELDS = "selected_fields";
    static final String FIELD_STATIC_MESSAGE_LIST_ID = "static_message_list_id";
    static final String FIELD_TITLES = "titles";
    static final String FIELD_WIDGETS = "widgets";
    static final String FIELD_WIDGET_MAPPING = "widget_mapping";
    static final String FIELD_WIDGET_POSITIONS = "positions";
    static final String FIELD_FORMATTING = "formatting";
    static final String FIELD_DISPLAY_MODE_SETTINGS = "display_mode_settings";

    @Nullable
    @JsonProperty(value="selected_fields")
    public abstract Optional<Set<String>> fields();

    @Nullable
    @JsonProperty(value="static_message_list_id")
    public abstract Optional<String> staticMessageListId();

    @JsonProperty(value="titles")
    public abstract Titles titles();

    @JsonProperty(value="widgets")
    public abstract Set<WidgetDTO> widgets();

    @JsonProperty(value="widget_mapping")
    public abstract Map<String, Set<String>> widgetMapping();

    @JsonProperty(value="positions")
    public abstract Map<String, WidgetPositionDTO> widgetPositions();

    @JsonProperty(value="formatting")
    @Nullable
    public abstract FormattingSettings formatting();

    @JsonProperty(value="display_mode_settings")
    public abstract DisplayModeSettings displayModeSettings();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonIgnore
    public Optional<String> title() {
        return Optional.ofNullable(this.titles()).map(Titles::titles).map(titles -> (Map)titles.get("tab")).map(tab -> (String)tab.get("title"));
    }

    @Override
    public ViewStateEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        ViewStateEntity.Builder viewStateBuilder = ViewStateEntity.builder().titles(this.titles()).displayModeSettings(this.displayModeSettings()).formatting(this.formatting()).widgets(this.widgets().stream().map(widgetDTO -> widgetDTO.toContentPackEntity(entityDescriptorIds)).collect(Collectors.toSet())).widgetPositions(this.widgetPositions()).widgetMapping(this.widgetMapping());
        if (this.fields() != null && this.fields().isPresent()) {
            viewStateBuilder.fields(this.fields().get());
        }
        if (this.staticMessageListId() != null && this.staticMessageListId().isPresent()) {
            viewStateBuilder.staticMessageListId(this.staticMessageListId().get());
        }
        return viewStateBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @Nullable
        @JsonProperty(value="selected_fields")
        public abstract Builder fields(Set<String> var1);

        @Nullable
        @JsonProperty(value="static_message_list_id")
        public abstract Builder staticMessageListId(String var1);

        @JsonProperty(value="titles")
        public abstract Builder titles(Titles var1);

        @JsonProperty(value="widgets")
        public abstract Builder widgets(Set<WidgetDTO> var1);

        @JsonProperty(value="widget_mapping")
        public abstract Builder widgetMapping(Map<String, Set<String>> var1);

        @JsonProperty(value="positions")
        public abstract Builder widgetPositions(Map<String, WidgetPositionDTO> var1);

        @JsonProperty(value="formatting")
        public abstract Builder formatting(FormattingSettings var1);

        @JsonProperty(value="display_mode_settings")
        public abstract Builder displayModeSettings(DisplayModeSettings var1);

        public abstract ViewStateDTO build();

        @JsonCreator
        public static Builder create() {
            return new .AutoValue_ViewStateDTO.Builder().titles(Titles.empty()).displayModeSettings(DisplayModeSettings.empty());
        }
    }
}

