/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.AutoValue_IndexSetValidator_Violation;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class IndexSetValidator {
    private static final Duration MINIMUM_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)1L);
    private final IndexSetRegistry indexSetRegistry;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public IndexSetValidator(IndexSetRegistry indexSetRegistry, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.indexSetRegistry = indexSetRegistry;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    public Optional<Violation> validate(IndexSetConfig newConfig) {
        Violation prefixViolation;
        if (Strings.isNullOrEmpty((String)newConfig.id()) && (prefixViolation = this.validatePrefix(newConfig)) != null) {
            return Optional.of(prefixViolation);
        }
        Violation refreshIntervalViolation = this.validateRefreshInterval(newConfig);
        if (refreshIntervalViolation != null) {
            return Optional.of(refreshIntervalViolation);
        }
        return Optional.ofNullable(this.validateRetentionPeriod(newConfig));
    }

    @Nullable
    private Violation validateRefreshInterval(IndexSetConfig newConfig) {
        if (newConfig.fieldTypeRefreshInterval().isShorterThan((ReadableDuration)MINIMUM_FIELD_TYPE_REFRESH_INTERVAL)) {
            return Violation.create("Index field_type_refresh_interval \"" + newConfig.fieldTypeRefreshInterval().toString() + "\" is too short. It must be 1 second or longer.");
        }
        return null;
    }

    @Nullable
    private Violation validatePrefix(IndexSetConfig newConfig) {
        String indexName = newConfig.indexPrefix() + "_0";
        if (this.indexSetRegistry.isManagedIndex(indexName)) {
            return Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with an existing index set!");
        }
        for (IndexSet indexSet : this.indexSetRegistry) {
            if (!newConfig.indexPrefix().startsWith(indexSet.getIndexPrefix()) && !indexSet.getIndexPrefix().startsWith(newConfig.indexPrefix())) continue;
            return Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with existing index set prefix \"" + indexSet.getIndexPrefix() + "\"");
        }
        return null;
    }

    @Nullable
    private Violation validateRetentionPeriod(IndexSetConfig config) {
        Period maxRetentionPeriod = this.elasticsearchConfiguration.getMaxIndexRetentionPeriod();
        if (maxRetentionPeriod == null) {
            return null;
        }
        if (!(config.rotationStrategy() instanceof TimeBasedRotationStrategyConfig)) {
            return null;
        }
        Period rotationPeriod = ((TimeBasedRotationStrategyConfig)config.rotationStrategy()).rotationPeriod().normalizedStandard();
        Period effectiveRetentionPeriod = rotationPeriod.multipliedBy(config.retentionStrategy().maxNumberOfIndices()).normalizedStandard();
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        if (now.plus((ReadablePeriod)effectiveRetentionPeriod).isAfter((ReadableInstant)now.plus((ReadablePeriod)maxRetentionPeriod))) {
            return Violation.create(StringUtils.f("Index retention setting %s=%d would result in an effective index retention period of %s. This exceeds the configured maximum of %s=%s.", "max_number_of_indices", config.retentionStrategy().maxNumberOfIndices(), effectiveRetentionPeriod, "max_index_retention_period", maxRetentionPeriod));
        }
        return null;
    }

    @AutoValue
    public static abstract class Violation {
        public abstract String message();

        public static Violation create(String message) {
            return new AutoValue_IndexSetValidator_Violation(message);
        }
    }
}

