/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.parser.errors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.UnmodifiableIterator;
import org.graylog.plugins.pipelineprocessor.ast.exceptions.PrecomputeFailure;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.parser.RuleLangParser;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;

public class InvalidFunctionArgument
extends ParseError {
    private final Function<?> function;
    private final PrecomputeFailure failure;

    public InvalidFunctionArgument(RuleLangParser.FunctionCallContext ctx, Function<?> function, PrecomputeFailure failure) {
        super("invalid_function_argument", ctx);
        this.function = function;
        this.failure = failure;
    }

    @JsonProperty(value="reason")
    public String toString() {
        ParameterDescriptor descriptor;
        int paramPosition = 1;
        UnmodifiableIterator unmodifiableIterator = this.function.descriptor().params().iterator();
        while (unmodifiableIterator.hasNext() && !(descriptor = (ParameterDescriptor)unmodifiableIterator.next()).name().equals(this.failure.getArgumentName())) {
            ++paramPosition;
        }
        return "Unable to pre-compute value for " + InvalidFunctionArgument.ordinal(paramPosition) + " argument " + this.failure.getArgumentName() + " in call to function " + this.function.descriptor().name() + ": " + this.failure.getCause().getMessage();
    }

    private static String ordinal(int i) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + suffixes[i % 10];
    }
}

