/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.filter;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.graylog.plugins.sidecar.filter.AdministrationFilter;
import org.graylog.plugins.sidecar.rest.models.Sidecar;

public class AdministrationFiltersFactory {
    private final AdministrationFilter.Factory administrationFilterFactory;

    @Inject
    public AdministrationFiltersFactory(AdministrationFilter.Factory administrationFilterFactory) {
        this.administrationFilterFactory = administrationFilterFactory;
    }

    public Optional<Predicate<Sidecar>> getFilters(Map<String, String> filters) {
        return filters.entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            AdministrationFilter.Type filter = AdministrationFilter.Type.valueOf(name.toUpperCase(Locale.ENGLISH));
            switch (filter) {
                case COLLECTOR: {
                    return this.administrationFilterFactory.createCollectorFilter(value);
                }
                case CONFIGURATION: {
                    return this.administrationFilterFactory.createConfigurationFilter(value);
                }
                case OS: {
                    return this.administrationFilterFactory.createOsFilter(value);
                }
                case STATUS: {
                    return this.administrationFilterFactory.createStatusFilter(Integer.valueOf(value));
                }
            }
            return null;
        }).filter(Objects::nonNull).reduce(Predicate::and);
    }
}

