/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.AutoValue_V20200204122000_MigrateUntypedViewsToDashboards_MigrationCompleted;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.Query;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.Search;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.View;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.ViewState;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.Widget;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200204122000_MigrateUntypedViewsToDashboards
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200204122000_MigrateUntypedViewsToDashboards.class);
    private static final String COLLECTION_VIEWS = "views";
    private static final String COLLECTION_SEARCHES = "searches";
    private static final String FIELD_ID = "_id";
    private static final String FIELD_TYPE = "type";
    private final MongoCollection<Document> viewsCollection;
    private final MongoCollection<Document> searchesCollections;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20200204122000_MigrateUntypedViewsToDashboards(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.viewsCollection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_VIEWS);
        this.searchesCollections = mongoConnection.getMongoDatabase().getCollection(COLLECTION_SEARCHES);
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-02-04T12:20:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        ArrayList<String> viewIds = new ArrayList<String>();
        FindIterable documents = this.viewsCollection.find(Filters.not((Bson)Filters.exists((String)FIELD_TYPE)));
        for (Document viewDocument : documents) {
            View view = new View(viewDocument);
            ObjectId viewId = view.objectId();
            String searchId = view.searchId();
            if (searchId == null) {
                LOG.warn("View <" + viewId.toString() + "> does not reference valid search - skipping!");
                continue;
            }
            Optional<Search> optionalSearch = this.findSearch(searchId);
            optionalSearch.ifPresent(search -> {
                view.makeDashboard();
                this.migrateViewStates(view, (Search)search);
                this.migrateQueries((Search)search);
                this.updateView(view, viewId);
                this.updateSearch((Search)search, searchId);
                viewIds.add(viewId.toString());
            });
            if (optionalSearch.isPresent()) continue;
            LOG.warn("Search <" + searchId + "> not found for viewDocument <" + viewId.toString() + "> - skipping!");
        }
        this.clusterConfigService.write(MigrationCompleted.create(viewIds));
    }

    private void updateSearch(Search search, String searchId) {
        this.searchesCollections.updateOne((Bson)new BasicDBObject(FIELD_ID, (Object)new ObjectId(searchId)), (Bson)new Document("$set", (Object)search.searchDocument()));
    }

    private void updateView(View view, ObjectId viewId) {
        this.viewsCollection.updateOne((Bson)new BasicDBObject(FIELD_ID, (Object)viewId), (Bson)new Document("$set", (Object)view.viewDocument()));
    }

    private Optional<Search> findSearch(String searchId) {
        Document search = (Document)this.searchesCollections.find(Filters.eq((String)FIELD_ID, (Object)new ObjectId(searchId))).first();
        if (search == null) {
            return Optional.empty();
        }
        return Optional.of(new Search(search));
    }

    private void migrateViewStates(View view, Search search) {
        view.viewStates().forEach((id, viewState) -> {
            if (viewState == null) {
                return;
            }
            Optional<Query> searchQuery = search.queryById((String)id);
            searchQuery.ifPresent(query -> this.migrateSingleViewState((ViewState)viewState, (Query)query));
        });
    }

    private void migrateSingleViewState(ViewState viewState, Query query) {
        viewState.widgets().forEach(widget -> {
            widget.mergeFilterIntoQueryIfPresent();
            widget.mergeQuerySpecsIntoWidget(query);
            query.mergeWidgetSettingsIntoSearchTypes((Widget)widget, viewState.searchTypeIdsForWidgetId(widget.id()));
        });
    }

    private void migrateQueries(Search search) {
        search.queries().forEach(Query::clearUnwantedProperties);
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="viewIds")
        public abstract List<String> viewIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="viewIds") List<String> viewIds) {
            return new AutoValue_V20200204122000_MigrateUntypedViewsToDashboards_MigrationCompleted(viewIds);
        }
    }
}

