/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Exportable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.SearchTypeExecutionState;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=Fallback.class)
@JsonAutoDetect
public interface SearchType
extends ContentPackable<SearchTypeEntity>,
Exportable {
    public static final String TYPE_FIELD = "type";
    public static final String FIELD_SEARCH_FILTERS = "filters";

    @JsonProperty(value="type")
    public String type();

    @JsonProperty(value="id")
    public String id();

    @JsonProperty
    public Optional<String> name();

    @Nullable
    @JsonProperty(value="filter")
    public Filter filter();

    @JsonProperty(value="filters")
    public List<UsedSearchFilter> filters();

    @JsonProperty
    public Optional<DerivedTimeRange> timerange();

    @JsonProperty
    public Optional<BackendQuery> query();

    @JsonProperty
    public Set<String> streams();

    public SearchType applyExecutionContext(SearchTypeExecutionState var1);

    public SearchType withQuery(BackendQuery var1);

    public SearchType withFilter(Filter var1);

    default public Set<String> effectiveStreams() {
        return this.streams();
    }

    public SearchType withFilters(List<UsedSearchFilter> var1);

    default public Set<String> mappedStreams(EntityDescriptorIds entityDescriptorIds) {
        return this.streams().stream().map(streamId -> entityDescriptorIds.get(EntityDescriptor.create(streamId, ModelTypes.STREAM_V1))).map(optionalStreamId -> (String)optionalStreamId.orElseThrow(() -> new ContentPackException("Did not find matching stream id"))).collect(Collectors.toSet());
    }

    @JsonAutoDetect
    public static class Fallback
    implements SearchType {
        @JsonProperty
        private String type;
        @JsonProperty
        private String id;
        @JsonProperty
        private Optional<String> name;
        private Map<String, Object> props = Maps.newHashMap();
        @Nullable
        @JsonProperty
        private Filter filter;
        @Nullable
        @JsonProperty(value="filters")
        private List<UsedSearchFilter> filters;
        @Nullable
        @JsonProperty
        private DerivedTimeRange timeRange;
        @Nullable
        @JsonProperty
        private BackendQuery query;
        @JsonProperty
        private Set<String> streams;

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<String> name() {
            return this.name;
        }

        @Override
        public Filter filter() {
            return this.filter;
        }

        @Override
        public List<UsedSearchFilter> filters() {
            return this.filters;
        }

        @Override
        public Optional<DerivedTimeRange> timerange() {
            return Optional.ofNullable(this.timeRange);
        }

        @Override
        public Optional<BackendQuery> query() {
            return Optional.ofNullable(this.query);
        }

        @Override
        public Set<String> streams() {
            return this.streams == null ? Collections.emptySet() : this.streams;
        }

        @Override
        public SearchType applyExecutionContext(SearchTypeExecutionState state) {
            return this;
        }

        @Override
        public SearchType withQuery(BackendQuery query) {
            return this;
        }

        @Override
        public SearchType withFilter(Filter filter) {
            return this;
        }

        @Override
        public SearchType withFilters(List<UsedSearchFilter> filters) {
            return this;
        }

        @JsonAnySetter
        public void setProperties(String key, Object value) {
            this.props.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, Object> getProperties() {
            return this.props;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fallback fallback = (Fallback)o;
            return Objects.equals(this.type, fallback.type) && Objects.equals(this.id, fallback.id) && Objects.equals(this.props, fallback.props);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id, this.props);
        }

        @Override
        public SearchTypeEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
            return null;
        }
    }

    public static interface Result {
        @JsonProperty(value="id")
        public String id();

        @JsonProperty(value="type")
        public String type();

        @JsonProperty
        public Optional<String> name();
    }
}

