/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.permissions;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.permissions.SearchPermissions;
import org.graylog.plugins.views.search.permissions.StreamPermissions;
import org.graylog.plugins.views.search.permissions.UserStreams;
import org.graylog.plugins.views.search.permissions.ViewPermissions;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewLike;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.plugins.views.search.views.ViewResolverDecoder;
import org.graylog2.plugin.database.users.User;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUser
implements SearchPermissions,
StreamPermissions,
ViewPermissions {
    private static final Logger LOG = LoggerFactory.getLogger(SearchUser.class);
    private final User currentUser;
    private final Predicate<String> isPermitted;
    private final BiPredicate<String, String> isPermittedEntity;
    private final UserStreams userStreams;
    private final Map<String, ViewResolver> viewResolvers;

    public SearchUser(User currentUser, Predicate<String> isPermitted, BiPredicate<String, String> isPermittedEntity, PermittedStreams permittedStreams, Map<String, ViewResolver> viewResolvers) {
        this.currentUser = currentUser;
        this.isPermitted = isPermitted;
        this.isPermittedEntity = isPermittedEntity;
        this.userStreams = new UserStreams(this, permittedStreams);
        this.viewResolvers = viewResolvers;
    }

    public Optional<DateTimeZone> timeZone() {
        return Optional.ofNullable(this.currentUser.getTimeZone());
    }

    public String username() {
        return this.currentUser.getName();
    }

    @Override
    public boolean canReadView(ViewLike view) {
        String viewId = view.id();
        ViewResolverDecoder decoder = new ViewResolverDecoder(viewId);
        if (decoder.isResolverViewId()) {
            ViewResolver viewResolver = this.viewResolvers.get(decoder.getResolverName());
            if (viewResolver != null) {
                return viewResolver.canReadView(viewId, this.isPermitted, this.isPermittedEntity);
            }
            LOG.error("View resolver [{}] could not be found.", (Object)decoder.getResolverName());
            return false;
        }
        return this.isPermitted("view:read", viewId) || view.type().equals((Object)ViewDTO.Type.DASHBOARD) && this.isPermitted("dashboards:read", viewId);
    }

    @Override
    public boolean canCreateDashboards() {
        return this.isPermitted("dashboards:create");
    }

    @Override
    public boolean canUpdateView(ViewLike view) {
        return view.type().equals((Object)ViewDTO.Type.DASHBOARD) ? this.isPermitted("view:edit", view.id()) || this.isPermitted("dashboards:edit", view.id()) : this.isPermitted("view:edit", view.id());
    }

    @Override
    public boolean canDeleteView(ViewLike view) {
        return this.isPermitted("view:delete", view.id());
    }

    @Override
    public boolean canReadStream(String streamId) {
        return this.isPermitted("streams:read", streamId);
    }

    private boolean isPermitted(String permission) {
        return this.isPermitted.test(permission);
    }

    private boolean isPermitted(String permission, String entityId) {
        return this.isPermittedEntity.test(permission, entityId);
    }

    @Override
    public boolean owns(Search search) {
        return search.owner().map(o -> o.equals(this.username())).orElse(true);
    }

    public boolean isAdmin() {
        return this.currentUser.isLocalAdmin() || this.isPermitted("*");
    }

    public UserStreams streams() {
        return this.userStreams;
    }

    public User getUser() {
        return this.currentUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchUser that = (SearchUser)o;
        return Objects.equal((Object)this.currentUser, (Object)that.currentUser);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.currentUser});
    }
}

