/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.ldap;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.graylog.security.authservice.ldap.AutoValue_LDAPEntry;

@AutoValue
public abstract class LDAPEntry {
    public abstract String dn();

    public abstract String base64UniqueId();

    public abstract ImmutableSet<String> objectClasses();

    public abstract ImmutableListMultimap<String, String> attributes();

    public boolean hasAttribute(String key) {
        return this.attributes().containsKey((Object)LDAPEntry.toKey(key));
    }

    public Optional<ImmutableList<String>> allAttributeValues(String key) {
        return Optional.ofNullable(this.attributes().get((Object)LDAPEntry.toKey(key)));
    }

    public Optional<String> firstAttributeValue(String key) {
        return Optional.ofNullable(this.attributes().get((Object)LDAPEntry.toKey(key))).filter(values -> !values.isEmpty()).map(values -> (String)values.get(0));
    }

    public String nonBlankAttribute(String key) {
        String value = this.firstAttributeValue(key).orElse(null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("Value for key <" + key + "> cannot be blank");
        }
        return value;
    }

    public static Builder builder() {
        return Builder.create();
    }

    private static String toKey(String key) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)key) ? 1 : 0) != 0, (Object)"key cannot be blank");
        return key.toLowerCase(Locale.ENGLISH);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public static Builder create() {
            return new AutoValue_LDAPEntry.Builder().objectClasses(Collections.emptySet());
        }

        public abstract Builder dn(String var1);

        public abstract Builder base64UniqueId(String var1);

        public abstract Builder objectClasses(Collection<String> var1);

        public abstract ImmutableListMultimap.Builder<String, String> attributesBuilder();

        public Builder addAttribute(String key, String value) {
            if (value != null) {
                this.attributesBuilder().put((Object)LDAPEntry.toKey(key), (Object)value);
            }
            return this;
        }

        public abstract LDAPEntry build();
    }
}

