/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.periodical;

import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Periodical
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Periodical.class);

    public abstract boolean runsForever();

    public abstract boolean stopOnGracefulShutdown();

    @Deprecated
    public boolean masterOnly() {
        return false;
    }

    public boolean leaderOnly() {
        return this.masterOnly();
    }

    public abstract boolean startOnThisNode();

    public abstract boolean isDaemon();

    public abstract int getInitialDelaySeconds();

    public abstract int getPeriodSeconds();

    public void initialize() {
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (RuntimeException e) {
            Logger logger = this.getLogger();
            if (logger != null) {
                logger.error("Uncaught exception in Periodical", (Throwable)e);
            }
            LOG.error("Uncaught exception in Periodical", (Throwable)e);
        }
    }

    @Nonnull
    protected abstract Logger getLogger();

    public abstract void doRun();

    public int getParallelism() {
        return 1;
    }
}

