/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.rest.models.tools.requests.LookupTableTestRequest;
import org.graylog2.rest.resources.tools.responses.LookupTableTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/lookup_table_tester")
@Produces(value={"application/json"})
public class LookupTableTesterResource
extends RestResource {
    private final LookupTableService lookupTableService;

    @Inject
    public LookupTableTesterResource(LookupTableService lookupTableService) {
        this.lookupTableService = lookupTableService;
    }

    @GET
    @Timed
    public LookupTableTesterResponse grokTest(@QueryParam(value="lookup_table_name") @NotEmpty String lookupTableName, @QueryParam(value="string") @NotEmpty String string) {
        return this.doTestLookupTable(string, lookupTableName);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test lookup tables")
    @RequiresPermissions(value={"lookuptables:read"})
    public LookupTableTesterResponse testLookupTable(@Valid @NotNull LookupTableTestRequest lookupTableTestRequest) {
        return this.doTestLookupTable(lookupTableTestRequest.string(), lookupTableTestRequest.lookupTableName());
    }

    private LookupTableTesterResponse doTestLookupTable(String string, String lookupTableName) {
        if (!this.lookupTableService.hasTable(lookupTableName)) {
            return LookupTableTesterResponse.error("Lookup table <" + lookupTableName + "> doesn't exist");
        }
        LookupTableService.Function table = this.lookupTableService.newBuilder().lookupTable(lookupTableName).build();
        LookupResult result = table.lookup(string.trim());
        if (result == null) {
            return LookupTableTesterResponse.emptyResult(string);
        }
        return LookupTableTesterResponse.result(string, result);
    }
}

