/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.metrics.prometheus.mapping.AutoValue_MetricMatchMapping_Config;
import org.graylog.metrics.prometheus.mapping.MetricMapping;
import org.graylog2.plugin.system.NodeId;

public class MetricMatchMapping
implements MetricMapping {
    public static final String TYPE = "metric_match";
    private final NodeId nodeId;
    private final Config config;

    @Inject
    public MetricMatchMapping(NodeId nodeId, @Assisted MetricMapping.Config config) {
        this.nodeId = nodeId;
        this.config = (Config)config;
    }

    public Set<MapperConfig> toMapperConfigs() {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("node", this.nodeId.toString());
        labels.putAll((Map<String, Object>)this.config.additionalLabels());
        for (int i = 0; i < this.config.wildcardExtractLabels().size(); ++i) {
            labels.put((String)this.config.wildcardExtractLabels().get(i), "${" + i + "}");
        }
        return Collections.singleton(new MapperConfig(this.config.matchPattern(), "gl_" + this.config.metricName(), labels));
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements MetricMapping.Config {
        @JsonProperty(value="match_pattern")
        public abstract String matchPattern();

        @JsonProperty(value="wildcard_extract_labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public abstract ImmutableList<String> wildcardExtractLabels();

        @JsonProperty(value="additional_labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public abstract ImmutableMap<String, String> additionalLabels();

        public static Builder builder() {
            return Builder.create();
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements MetricMapping.Config.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_MetricMatchMapping_Config.Builder().type(MetricMatchMapping.TYPE).wildcardExtractLabels((List<String>)ImmutableList.of()).additionalLabels((Map<String, String>)ImmutableMap.of());
            }

            @JsonProperty(value="match_pattern")
            public abstract Builder matchPattern(String var1);

            @JsonProperty(value="wildcard_extract_labels")
            public abstract Builder wildcardExtractLabels(List<String> var1);

            @JsonProperty(value="additional_labels")
            public abstract Builder additionalLabels(Map<String, String> var1);

            public abstract Config build();
        }
    }

    public static interface Factory
    extends MetricMapping.Factory<MetricMatchMapping> {
        @Override
        public MetricMatchMapping create(MetricMapping.Config var1);
    }
}

