/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PipelineServiceHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PipelineRuleParser pipelineParser;

    @Inject
    public PipelineServiceHelper(PipelineRuleParser pipelineRuleParser) {
        this.pipelineParser = pipelineRuleParser;
    }

    @Nonnull
    public Map<String, List<PipelineDao>> groupByRuleName(@Nonnull Supplier<Collection<PipelineDao>> pipelines, @Nonnull Set<String> ruleNames) {
        if (ruleNames.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap result = new HashMap();
        pipelines.get().stream().flatMap(pipelineDao -> {
            try {
                Pipeline parsedPipeline = this.pipelineParser.parsePipeline(pipelineDao.id(), pipelineDao.source());
                return Stream.of(new ParsedPipelineWithSource((PipelineDao)pipelineDao, parsedPipeline));
            }
            catch (ParseException e) {
                this.logger.warn("Ignoring non-parseable pipeline <{}/{}> with errors <{}>", new Object[]{pipelineDao.title(), pipelineDao.id(), e.getErrors()});
                return Stream.empty();
            }
        }).forEach(pp -> {
            for (String ruleName : ruleNames) {
                if (!result.containsKey(ruleName)) {
                    result.put(ruleName, new ArrayList());
                }
                if (!pp.parsed.containsRule(ruleName)) continue;
                ((List)result.get(ruleName)).add(pp.source);
            }
        });
        return ImmutableMap.copyOf(result);
    }

    static final class ParsedPipelineWithSource {
        private final PipelineDao source;
        private final Pipeline parsed;

        ParsedPipelineWithSource(@Nonnull PipelineDao source, @Nonnull Pipeline parsed) {
            this.source = source;
            this.parsed = parsed;
        }
    }
}

