/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.AggregationSpecToPivotMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;

public class SearchRequestSpecToSearchMapper {
    public static final String QUERY_ID = "scripting_api_temporary_query";
    private final AggregationSpecToPivotMapper pivotCreator;

    @Inject
    public SearchRequestSpecToSearchMapper(AggregationSpecToPivotMapper pivotCreator) {
        this.pivotCreator = pivotCreator;
    }

    public Search mapToSearch(SearchRequestSpec searchRequestSpec, SearchUser searchUser) {
        Query query = Query.builder().id(QUERY_ID).searchTypes(Set.of(this.pivotCreator.apply(searchRequestSpec))).query(searchRequestSpec.queryString() != null ? ElasticsearchQueryString.of(searchRequestSpec.queryString()) : ElasticsearchQueryString.empty()).timerange(searchRequestSpec.timerange() != null ? searchRequestSpec.timerange() : RelativeRange.allTime()).build();
        if (!searchRequestSpec.streams().isEmpty()) {
            query = query.addStreamsToFilter(new HashSet<String>(searchRequestSpec.streams()));
        }
        Search search = Search.builder().queries((ImmutableSet<Query>)ImmutableSet.of((Object)query)).build();
        search = search.addStreamsToQueriesWithoutStreams(() -> searchUser.streams().readableOrAllIfEmpty(searchRequestSpec.streams()));
        return search;
    }
}

