/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.configuration.MongoDbConfiguration;
import org.graylog2.database.MongoConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoConnectionImpl
implements MongoConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MongoConnectionImpl.class);
    private final MongoClientURI mongoClientURI;
    private MongoClient m = null;
    private DB db = null;
    private MongoDatabase mongoDatabase = null;

    @Inject
    public MongoConnectionImpl(MongoDbConfiguration configuration) {
        this(configuration.getMongoClientURI());
    }

    MongoConnectionImpl(MongoClientURI mongoClientURI) {
        this.mongoClientURI = (MongoClientURI)Preconditions.checkNotNull((Object)mongoClientURI);
    }

    @Override
    public synchronized MongoClient connect() {
        if (this.m == null) {
            String dbName = this.mongoClientURI.getDatabase();
            if (Strings.isNullOrEmpty((String)dbName)) {
                LOG.error("The MongoDB database name must not be null or empty (mongodb_uri was: {})", (Object)this.mongoClientURI);
                throw new RuntimeException("MongoDB database name is missing.");
            }
            this.m = new MongoClient(this.mongoClientURI);
            this.db = this.m.getDB(dbName);
            this.db.setWriteConcern(WriteConcern.ACKNOWLEDGED);
            this.mongoDatabase = this.m.getDatabase(dbName).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        }
        try {
            this.db.command("{ ping: 1 }");
        }
        catch (MongoCommandException e) {
            if (e.getCode() == 18) {
                throw new MongoException("Couldn't connect to MongoDB. Please check the authentication credentials.", (Throwable)e);
            }
            throw new MongoException("Couldn't connect to MongoDB: " + e.getMessage(), (Throwable)e);
        }
        return this.m;
    }

    @Override
    public DB getDatabase() {
        return this.db;
    }

    @Override
    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }
}

