/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.health;

import java.util.Locale;
import org.graylog2.indexer.cluster.health.ByteSize;

public class SIUnitParser {
    private static final long C0 = 1L;
    private static final long C1 = 1024L;
    private static final long C2 = 0x100000L;
    private static final long C3 = 0x40000000L;
    private static final long C4 = 0x10000000000L;
    private static final long C5 = 0x4000000000000L;

    private static Long toLong(String value) {
        String lowerSValue = value.toLowerCase(Locale.ROOT).trim();
        if (lowerSValue.endsWith("k")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1024.0);
        }
        if (lowerSValue.endsWith("kb")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1024.0);
        }
        if (lowerSValue.endsWith("m")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1048576.0);
        }
        if (lowerSValue.endsWith("mb")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1048576.0);
        }
        if (lowerSValue.endsWith("g")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.073741824E9);
        }
        if (lowerSValue.endsWith("gb")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.073741824E9);
        }
        if (lowerSValue.endsWith("t")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.099511627776E12);
        }
        if (lowerSValue.endsWith("tb")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.099511627776E12);
        }
        if (lowerSValue.endsWith("p")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.125899906842624E15);
        }
        if (lowerSValue.endsWith("pb")) {
            return (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.125899906842624E15);
        }
        if (lowerSValue.endsWith("b")) {
            return Long.parseLong(lowerSValue.substring(0, lowerSValue.length() - 1).trim());
        }
        if (lowerSValue.equals("-1")) {
            return -1L;
        }
        if (lowerSValue.equals("0")) {
            return 0L;
        }
        return null;
    }

    public static ByteSize parseBytesSizeValue(String value) {
        Long longValue = SIUnitParser.toLong(value);
        if (longValue == null) {
            return null;
        }
        return () -> longValue;
    }
}

