/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationRequest {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationRequest.class);
    private static final String WILDCARD_IP_ADDRESS = "0.0.0.0";
    private final Map<String, ConfigurationField> fields = Maps.newLinkedHashMap();

    public void putAll(Map<String, ConfigurationField> fields) {
        this.fields.putAll(fields);
    }

    public void addField(ConfigurationField f) {
        this.fields.put(f.getName(), f);
    }

    public void addFields(List<ConfigurationField> fields) {
        fields.forEach(this::addField);
    }

    public boolean containsField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public ConfigurationField getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public Map<String, ConfigurationField> getFields() {
        return this.fields;
    }

    @Deprecated
    public boolean removeField(String fieldName) {
        return this.fields.remove(fieldName) != null;
    }

    public static ConfigurationRequest createWithFields(ConfigurationField ... fields) {
        ConfigurationRequest configurationRequest = new ConfigurationRequest();
        configurationRequest.addFields(Lists.newArrayList((Object[])fields));
        return configurationRequest;
    }

    @JsonValue
    public Map<String, Map<String, Object>> asList() {
        LinkedHashMap configs = Maps.newLinkedHashMap();
        for (ConfigurationField f : this.fields.values()) {
            HashMap config = Maps.newHashMap();
            config.put("type", f.getFieldType());
            config.put("human_name", f.getHumanName());
            config.put("description", f.getDescription());
            config.put("default_value", f.getDefaultValue());
            config.put("is_optional", f.isOptional().equals((Object)ConfigurationField.Optional.OPTIONAL));
            config.put("attributes", f.getAttributes());
            config.put("additional_info", f.getAdditionalInformation());
            config.put("position", f.getPosition());
            configs.put(f.getName(), config);
        }
        return configs;
    }

    public void check(Configuration configuration) throws ConfigurationException {
        block13: for (ConfigurationField field : this.fields.values()) {
            if (!field.isOptional().equals((Object)ConfigurationField.Optional.NOT_OPTIONAL)) continue;
            String type = field.getFieldType();
            String fieldName = field.getName();
            log.debug("Checking for mandatory field \"{}\" of type {} in configuration", (Object)fieldName, (Object)type);
            switch (type) {
                case "boolean": {
                    if (configuration.booleanIsSet(fieldName)) continue block13;
                    throw new ConfigurationException("Mandatory configuration field \"" + fieldName + "\" is missing or has the wrong data type");
                }
                case "number": {
                    if (configuration.intIsSet(fieldName)) continue block13;
                    throw new ConfigurationException("Mandatory configuration field \"" + fieldName + "\" is missing or has the wrong data type");
                }
                case "list": {
                    if (configuration.listIsSet(fieldName)) continue block13;
                    throw new ConfigurationException("Mandatory configuration field \"" + fieldName + "\" is missing or has the wrong data type");
                }
                case "text": 
                case "dropdown": {
                    if (configuration.stringIsSet(fieldName)) continue block13;
                    throw new ConfigurationException("Mandatory configuration field \"" + fieldName + "\" is missing or has the wrong data type");
                }
            }
            throw new IllegalStateException("Unknown field type " + type + " for configuration field \"" + fieldName + "\". This is a bug.");
        }
    }

    @Nonnull
    public Configuration filter(Configuration config) {
        HashMap values = Maps.newHashMap();
        block13: for (ConfigurationField field : this.fields.values()) {
            String type;
            String name = field.getName();
            switch (type = field.getFieldType()) {
                case "boolean": {
                    if (!config.booleanIsSet(name)) continue block13;
                    values.put(name, config.getBoolean(name));
                    continue block13;
                }
                case "number": {
                    if (!config.intIsSet(name)) continue block13;
                    values.put(name, config.getInt(name));
                    continue block13;
                }
                case "list": {
                    if (!config.listIsSet(name)) continue block13;
                    values.put(name, config.getList(name));
                    continue block13;
                }
                case "text": 
                case "dropdown": {
                    if (!config.stringIsSet(name)) continue block13;
                    values.put(name, config.getString(name));
                    continue block13;
                }
            }
            throw new IllegalStateException("Unknown field type " + type + " for configuration field \"" + name + "\". This is a bug.");
        }
        return new Configuration(values);
    }

    public static class Templates {
        public static ConfigurationField bindAddress(String name) {
            return new TextField(name, "Bind address", ConfigurationRequest.WILDCARD_IP_ADDRESS, "Address to listen on. For example 0.0.0.0 or 127.0.0.1.", new TextField.Attribute[0]);
        }

        public static ConfigurationField portNumber(String name, int port) {
            return new NumberField(name, "Port", port, "Port to listen on.", NumberField.Attribute.IS_PORT_NUMBER);
        }

        public static ConfigurationField recvBufferSize(String name, int size) {
            return new NumberField(name, "Receive Buffer Size", size, "The size in bytes of the recvBufferSize for network connections to this input.", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE);
        }
    }
}

