/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.decorators.Decorator;
import org.graylog2.decorators.DecoratorImpl;
import org.graylog2.decorators.DecoratorService;
import org.graylog2.plugin.configuration.ConfigurableTypeInfo;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Decorators", description="Message search decorators", tags={"cloud"})
@Path(value="/search/decorators")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DecoratorResource
extends RestResource {
    private final DecoratorService decoratorService;
    private final Map<String, SearchResponseDecorator.Factory> searchResponseDecorators;

    @Inject
    public DecoratorResource(DecoratorService decoratorService, Map<String, SearchResponseDecorator.Factory> searchResponseDecorators) {
        this.decoratorService = decoratorService;
        this.searchResponseDecorators = searchResponseDecorators;
    }

    @GET
    @Timed
    @ApiOperation(value="Returns all configured message decorations")
    public List<Decorator> get() {
        this.checkPermission("decorators:read");
        return this.decoratorService.findAll();
    }

    @GET
    @Timed
    @Path(value="/available")
    @ApiOperation(value="Returns all available message decorations", notes="")
    public Map<String, ConfigurableTypeInfo> getAvailable() {
        return this.searchResponseDecorators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ConfigurableTypeInfo.create((String)entry.getKey(), ((SearchResponseDecorator.Factory)entry.getValue()).getDescriptor(), ((SearchResponseDecorator.Factory)entry.getValue()).getConfig().getRequestedConfiguration())));
    }

    @POST
    @Timed
    @ApiOperation(value="Creates a message decoration configuration")
    @AuditEvent(type="server:message_decorator:create")
    public Decorator create(@ApiParam(name="JSON body", required=true) @Valid @NotNull DecoratorImpl decorator) {
        this.checkPermission("decorators:create");
        if (decorator.stream().isPresent()) {
            this.checkPermission("streams:edit", decorator.stream().get());
        }
        return this.decoratorService.save(decorator);
    }

    @DELETE
    @Path(value="/{decoratorId}")
    @Timed
    @ApiOperation(value="Create a decorator")
    @AuditEvent(type="server:message_decorator:delete")
    public void delete(@ApiParam(name="decorator id", required=true) @PathParam(value="decoratorId") String decoratorId) throws NotFoundException {
        this.checkPermission("decorators:edit");
        Decorator decorator = this.decoratorService.findById(decoratorId);
        if (decorator.stream().isPresent()) {
            this.checkPermission("streams:edit", decorator.stream().get());
        }
        this.decoratorService.delete(decoratorId);
    }

    @PUT
    @Path(value="/{decoratorId}")
    @Timed
    @ApiOperation(value="Update a decorator")
    @AuditEvent(type="server:message_decorator:update")
    public Decorator update(@ApiParam(name="decorator id", required=true) @PathParam(value="decoratorId") String decoratorId, @ApiParam(name="JSON body", required=true) @Valid @NotNull DecoratorImpl decorator) throws NotFoundException {
        Decorator originalDecorator = this.decoratorService.findById(decoratorId);
        this.checkPermission("decorators:create");
        if (originalDecorator.stream().isPresent()) {
            this.checkPermission("streams:edit", originalDecorator.stream().get());
        }
        return this.decoratorService.save(decorator.toBuilder().id(originalDecorator.id()).build());
    }
}

