/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.failure;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.graylog.failure.FailureBatch;
import org.graylog.failure.FailureHandler;
import org.graylog2.indexer.IndexFailureImpl;
import org.graylog2.indexer.IndexFailureService;

public class DefaultFailureHandler
implements FailureHandler {
    private final IndexFailureService indexFailureService;

    @Inject
    public DefaultFailureHandler(IndexFailureService indexFailureService) {
        this.indexFailureService = indexFailureService;
    }

    @Override
    public void handle(FailureBatch failureBatch) {
        failureBatch.getFailures().forEach(failure -> this.indexFailureService.saveWithoutValidation(new IndexFailureImpl((Map<String, Object>)ImmutableMap.builder().put((Object)"letter_id", (Object)failure.failedMessage().getId()).put((Object)"index", (Object)failure.targetIndex()).put((Object)"type", (Object)failure.failureType().toString()).put((Object)"message", (Object)failure.failureDetails()).put((Object)"timestamp", (Object)failure.failedMessage().getTimestamp()).build())));
    }

    @Override
    public boolean supports(FailureBatch failureBatch) {
        return failureBatch.containsIndexingFailures();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

