/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus.mapping;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.graylog.metrics.prometheus.mapping.MetricMatchMapping;

final class AutoValue_MetricMatchMapping_Config
extends MetricMatchMapping.Config {
    private final String type;
    private final String metricName;
    private final String matchPattern;
    private final ImmutableList<String> wildcardExtractLabels;
    private final ImmutableMap<String, String> additionalLabels;

    private AutoValue_MetricMatchMapping_Config(String type, String metricName, String matchPattern, ImmutableList<String> wildcardExtractLabels, ImmutableMap<String, String> additionalLabels) {
        this.type = type;
        this.metricName = metricName;
        this.matchPattern = matchPattern;
        this.wildcardExtractLabels = wildcardExtractLabels;
        this.additionalLabels = additionalLabels;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="metric_name")
    public String metricName() {
        return this.metricName;
    }

    @Override
    @JsonProperty(value="match_pattern")
    public String matchPattern() {
        return this.matchPattern;
    }

    @Override
    @JsonProperty(value="wildcard_extract_labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<String> wildcardExtractLabels() {
        return this.wildcardExtractLabels;
    }

    @Override
    @JsonProperty(value="additional_labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableMap<String, String> additionalLabels() {
        return this.additionalLabels;
    }

    public String toString() {
        return "Config{type=" + this.type + ", metricName=" + this.metricName + ", matchPattern=" + this.matchPattern + ", wildcardExtractLabels=" + this.wildcardExtractLabels + ", additionalLabels=" + this.additionalLabels + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricMatchMapping.Config) {
            MetricMatchMapping.Config that = (MetricMatchMapping.Config)o;
            return this.type.equals(that.type()) && this.metricName.equals(that.metricName()) && this.matchPattern.equals(that.matchPattern()) && this.wildcardExtractLabels.equals(that.wildcardExtractLabels()) && this.additionalLabels.equals(that.additionalLabels());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.metricName.hashCode();
        h$ *= 1000003;
        h$ ^= this.matchPattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.wildcardExtractLabels.hashCode();
        h$ *= 1000003;
        return h$ ^= this.additionalLabels.hashCode();
    }

    static final class Builder
    extends MetricMatchMapping.Config.Builder {
        private String type;
        private String metricName;
        private String matchPattern;
        private ImmutableList<String> wildcardExtractLabels;
        private ImmutableMap<String, String> additionalLabels;

        Builder() {
        }

        @Override
        public MetricMatchMapping.Config.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public MetricMatchMapping.Config.Builder metricName(String metricName) {
            if (metricName == null) {
                throw new NullPointerException("Null metricName");
            }
            this.metricName = metricName;
            return this;
        }

        @Override
        public MetricMatchMapping.Config.Builder matchPattern(String matchPattern) {
            if (matchPattern == null) {
                throw new NullPointerException("Null matchPattern");
            }
            this.matchPattern = matchPattern;
            return this;
        }

        @Override
        public MetricMatchMapping.Config.Builder wildcardExtractLabels(List<String> wildcardExtractLabels) {
            this.wildcardExtractLabels = ImmutableList.copyOf(wildcardExtractLabels);
            return this;
        }

        @Override
        public MetricMatchMapping.Config.Builder additionalLabels(Map<String, String> additionalLabels) {
            this.additionalLabels = ImmutableMap.copyOf(additionalLabels);
            return this;
        }

        @Override
        public MetricMatchMapping.Config build() {
            Object missing = "";
            if (this.type == null) {
                missing = (String)missing + " type";
            }
            if (this.metricName == null) {
                missing = (String)missing + " metricName";
            }
            if (this.matchPattern == null) {
                missing = (String)missing + " matchPattern";
            }
            if (this.wildcardExtractLabels == null) {
                missing = (String)missing + " wildcardExtractLabels";
            }
            if (this.additionalLabels == null) {
                missing = (String)missing + " additionalLabels";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_MetricMatchMapping_Config(this.type, this.metricName, this.matchPattern, this.wildcardExtractLabels, this.additionalLabels);
        }
    }
}

