/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.email.EmailFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattedEmailAlertSender
implements AlertSender {
    private static final Logger LOG = LoggerFactory.getLogger(FormattedEmailAlertSender.class);
    public static final String bodyTemplate = "##########\nAlert Description: ${check_result.resultDescription}\nDate: ${check_result.triggeredAt}\nStream ID: ${stream.id}\nStream title: ${stream.title}\nStream description: ${stream.description}\nAlert Condition Title: ${alertCondition.title}\n${if stream_url}Stream URL: ${stream_url}${end}\n\nTriggered condition: ${check_result.triggeredCondition}\n##########\n\n${if backlog}Last messages accounting for this alert:\n${foreach backlog message}${message}\n\n${end}${else}<No backlog>\n${end}\n";
    private final Engine templateEngine;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private Configuration pluginConfig;
    private final EmailConfiguration configuration;
    private final EmailFactory emailFactory;

    @Inject
    public FormattedEmailAlertSender(EmailConfiguration configuration, NotificationService notificationService, NodeId nodeId, Engine templateEngine, EmailFactory emailFactory) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
        this.emailFactory = emailFactory;
    }

    @Override
    public void initialize(Configuration configuration) {
        this.pluginConfig = configuration;
    }

    @VisibleForTesting
    String buildSubject(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        String template = this.pluginConfig == null || this.pluginConfig.getString("subject") == null ? "Graylog alert for stream: ${stream.title}: ${check_result.resultDescription}" : this.pluginConfig.getString("subject");
        Map<String, Object> model = this.getModel(stream, checkResult, backlog);
        return this.templateEngine.transform(template, model);
    }

    @VisibleForTesting
    String buildBody(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        String template = this.pluginConfig == null || this.pluginConfig.getString("body") == null ? bodyTemplate : this.pluginConfig.getString("body");
        Map<String, Object> model = this.getModel(stream, checkResult, backlog);
        return this.templateEngine.transform(template, model);
    }

    private Map<String, Object> getModel(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("stream", stream);
        model.put("check_result", checkResult);
        model.put("stream_url", this.buildStreamDetailsURL(this.configuration.getWebInterfaceUri(), checkResult, stream));
        model.put("alertCondition", checkResult.getTriggeredCondition());
        List messages = (List)MoreObjects.firstNonNull(backlog, Collections.emptyList());
        model.put("backlog", messages);
        model.put("backlog_size", messages.size());
        return model;
    }

    private String buildStreamDetailsURL(URI baseUri, AlertCondition.CheckResult checkResult, Stream stream) {
        if (baseUri == null || Strings.isNullOrEmpty((String)baseUri.getHost())) {
            return "Please configure 'transport_email_web_interface_url' in your Graylog configuration file.";
        }
        int time = 5;
        if (checkResult.getTriggeredCondition().getParameters().get("time") != null) {
            time = (Integer)checkResult.getTriggeredCondition().getParameters().get("time");
        }
        DateTime dateAlertEnd = checkResult.getTriggeredAt();
        DateTime dateAlertStart = dateAlertEnd.minusMinutes(time);
        String alertStart = Tools.getISO8601String(dateAlertStart);
        String alertEnd = Tools.getISO8601String(dateAlertEnd);
        return baseUri + "/streams/" + stream.getId() + "/messages?rangetype=absolute&from=" + alertStart + "&to=" + alertEnd + "&q=*";
    }

    @Override
    public void sendEmails(Stream stream, EmailRecipients recipients, AlertCondition.CheckResult checkResult) throws TransportConfigurationException, EmailException {
        this.sendEmails(stream, recipients, checkResult, null);
    }

    private void sendEmail(String emailAddress, Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) throws TransportConfigurationException, EmailException {
        LOG.debug("Sending mail to " + emailAddress);
        if (!this.configuration.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        SimpleEmail email = this.emailFactory.simpleEmail();
        if (this.pluginConfig != null && !Strings.isNullOrEmpty((String)this.pluginConfig.getString("sender"))) {
            email.setFrom(this.pluginConfig.getString("sender"));
        }
        email.setSubject(this.buildSubject(stream, checkResult, backlog));
        email.setMsg(this.buildBody(stream, checkResult, backlog));
        email.addTo(emailAddress);
        email.send();
    }

    @Override
    public void sendEmails(Stream stream, EmailRecipients recipients, AlertCondition.CheckResult checkResult, List<Message> backlog) throws TransportConfigurationException, EmailException {
        if (!this.configuration.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new RuntimeException("Cannot send emails: empty recipient list.");
        }
        Set<String> recipientsSet = recipients.getEmailRecipients();
        if (recipientsSet.size() == 0) {
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.NORMAL).addDetail("title", "Stream \"" + stream.getTitle() + "\" is alerted, but no recipients have been defined!").addDetail("description", "To fix this, go to the alerting configuration of the stream and add at least one alert recipient.");
            this.notificationService.publishIfFirst(notification);
        }
        for (String email : recipientsSet) {
            this.sendEmail(email, stream, checkResult, backlog);
        }
    }
}

