/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.event;

import de.huxhorn.sulky.ulid.ULID;
import javax.inject.Inject;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventFactory;
import org.graylog.events.event.EventImpl;
import org.graylog.events.processor.EventDefinition;
import org.graylog.util.HostnameProvider;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EventProcessorEventFactory
implements EventFactory {
    private final String source;
    private final ULID ulid;

    @Inject
    public EventProcessorEventFactory(ULID ulid, HostnameProvider hostnameProvider) {
        this.ulid = ulid;
        try {
            this.source = hostnameProvider.get().canonicalHostname();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get local hostname", e);
        }
    }

    @Deprecated
    public EventProcessorEventFactory(ULID ulid, NodeService nodeService, NodeId nodeId) {
        this.ulid = ulid;
        try {
            this.source = nodeService.byNodeId(nodeId).getHostname();
        }
        catch (NodeNotFoundException e) {
            throw new RuntimeException("Couldn't get node ID", e);
        }
    }

    @Override
    public Event createEvent(EventDefinition eventDefinition, DateTime eventTime, String message) {
        return new EventImpl(this.ulid.nextULID(), eventTime.withZone(DateTimeZone.UTC), eventDefinition.config().type(), eventDefinition.id(), message, this.source, eventDefinition.priority(), eventDefinition.alert());
    }
}

