/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.contexts;

import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.subject.Subject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.security.UserContext;
import org.graylog2.shared.security.ShiroPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUserFactory
implements Factory<SearchUser> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchUserFactory.class);
    private final ServiceLocator serviceLocator;
    private final PermittedStreams permittedStreams;
    private final Map<String, ViewResolver> viewResolvers;

    @Inject
    public SearchUserFactory(ServiceLocator serviceLocator, PermittedStreams permittedStreams, Map<String, ViewResolver> viewResolvers) {
        this.serviceLocator = serviceLocator;
        this.permittedStreams = permittedStreams;
        this.viewResolvers = viewResolvers;
    }

    public SearchUser provide() {
        UserContext userContext = (UserContext)this.serviceLocator.getService(UserContext.class, new Annotation[0]);
        SecurityContext securityContext = (SecurityContext)this.serviceLocator.getService(SecurityContext.class, new Annotation[0]);
        return new SearchUser(userContext.getUser(), permission -> this.isPermitted(securityContext, (String)permission), (permission, instanceId) -> this.isPermitted(securityContext, (String)permission, (String)instanceId), this.permittedStreams, this.viewResolvers);
    }

    protected Subject getSubject(SecurityContext securityContext) {
        if (securityContext == null) {
            LOG.error("Cannot retrieve current subject, SecurityContext isn't set.");
            return null;
        }
        Principal p = securityContext.getUserPrincipal();
        if (!(p instanceof ShiroPrincipal)) {
            String msg = "Unknown SecurityContext class " + securityContext + ", cannot continue.";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        ShiroPrincipal principal = (ShiroPrincipal)p;
        return principal.getSubject();
    }

    protected boolean isPermitted(SecurityContext securityContext, String permission, String instanceId) {
        return this.getSubject(securityContext).isPermitted(permission + ":" + instanceId);
    }

    protected boolean isPermitted(SecurityContext securityContext, String permission) {
        return this.getSubject(securityContext).isPermitted(permission);
    }

    public void dispose(SearchUser searchUser) {
    }
}

