/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.Metadata;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseEntryDataType;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseSchemaEntry;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

public class SearchTypeResultToTabularResponseMapper {
    public TabularResponse mapToResponse(SearchRequestSpec searchRequestSpec, PivotResult pivotResult) {
        int numGroupings = searchRequestSpec.groupings().size();
        int numMetrics = searchRequestSpec.metrics().size();
        int numColumns = numGroupings + numMetrics;
        ArrayList<ResponseSchemaEntry> schema = new ArrayList<ResponseSchemaEntry>(numColumns);
        searchRequestSpec.groupings().forEach(gr -> schema.add(ResponseSchemaEntry.groupBy(gr.fieldName())));
        searchRequestSpec.metrics().forEach(metric -> schema.add(ResponseSchemaEntry.metric(metric.functionName(), "latest".equals(metric.functionName()) ? ResponseEntryDataType.STRING : ResponseEntryDataType.NUMERIC, metric.fieldName())));
        AbsoluteRange effectiveTimerange = pivotResult.effectiveTimerange();
        return new TabularResponse(schema, pivotResult.rows().stream().map(pivRow -> {
            ArrayList<Object> row = new ArrayList<Object>(numColumns);
            ImmutableList<String> resultGroupings = pivRow.key();
            row.addAll((Collection<Object>)resultGroupings);
            for (int i = 0; i < numGroupings - resultGroupings.size(); ++i) {
                row.add("-");
            }
            ImmutableList<PivotResult.Value> values = pivRow.values();
            for (Metric metric : searchRequestSpec.metrics()) {
                row.add(values.stream().filter(value -> value.key().contains((Object)metric.sortColumnName())).findFirst().map(PivotResult.Value::value).orElse("-"));
            }
            return row;
        }).collect(Collectors.toList()), new Metadata(effectiveTimerange));
    }
}

