/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.graylog.plugins.views.search.views.;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewLike;
import org.graylog.plugins.views.search.views.ViewStateDTO;
import org.graylog.plugins.views.search.views.WidgetDTO;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.ViewEntity;
import org.graylog2.contentpacks.model.entities.ViewStateEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ViewDTO
implements ContentPackable<ViewEntity.Builder>,
ViewLike {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_SUMMARY = "summary";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_SEARCH_ID = "search_id";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_REQUIRES = "requires";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_OWNER = "owner";
    public static final ImmutableSet<String> SORT_FIELDS = ImmutableSet.of((Object)"id", (Object)"title", (Object)"created_at");

    @Override
    @ObjectId
    @Id
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @Override
    @JsonProperty(value="type")
    public abstract Type type();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="summary")
    public abstract String summary();

    @JsonProperty(value="description")
    public abstract String description();

    @JsonProperty(value="search_id")
    public abstract String searchId();

    @JsonProperty(value="properties")
    public abstract ImmutableSet<String> properties();

    @JsonProperty(value="requires")
    public abstract Map<String, PluginMetadataSummary> requires();

    @JsonProperty(value="state")
    public abstract Map<String, ViewStateDTO> state();

    @JsonProperty(value="owner")
    public abstract Optional<String> owner();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public static Set<String> idsFrom(Collection<ViewDTO> views) {
        return views.stream().map(ViewDTO::id).collect(Collectors.toSet());
    }

    public Optional<ViewStateDTO> findQueryContainingWidgetId(String widgetId) {
        return this.state().values().stream().filter(viewStateDTO -> viewStateDTO.widgets().stream().map(WidgetDTO::id).collect(Collectors.toSet()).contains(widgetId)).findFirst();
    }

    public Optional<WidgetDTO> findWidgetById(String widgetId) {
        return this.state().values().stream().flatMap(q -> q.widgets().stream()).filter(w -> w.id().equals(widgetId)).findFirst();
    }

    @JsonIgnore
    public Set<WidgetDTO> getAllWidgets() {
        return this.state().values().stream().flatMap(q -> q.widgets().stream()).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Optional<String> queryIdOfWidget(String widgetId) {
        return this.state().entrySet().stream().filter(entry -> ((ViewStateDTO)entry.getValue()).widgets().stream().map(WidgetDTO::id).collect(Collectors.toSet()).contains(widgetId)).map(Map.Entry::getKey).findFirst();
    }

    @Override
    public ViewEntity.Builder toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        LinkedHashMap<String, ViewStateEntity> viewStateMap = new LinkedHashMap<String, ViewStateEntity>(this.state().size());
        for (Map.Entry<String, ViewStateDTO> entry : this.state().entrySet()) {
            ViewStateDTO viewStateDTO = entry.getValue();
            ViewStateEntity viewStateEntity = viewStateDTO.toContentPackEntity(entityDescriptorIds);
            viewStateMap.put(entry.getKey(), viewStateEntity);
        }
        ViewEntity.Builder viewEntityBuilder = ViewEntity.builder().type(this.type()).title(ValueReference.of(this.title())).summary(ValueReference.of(this.summary())).description(ValueReference.of(this.description())).state(viewStateMap).requires(this.requires()).properties((Set<String>)this.properties()).createdAt(this.createdAt());
        if (this.owner().isPresent()) {
            viewEntityBuilder.owner(this.owner().get());
        }
        return viewEntityBuilder;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @ObjectId
        @Id
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(Type var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="summary")
        public abstract Builder summary(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="search_id")
        public abstract Builder searchId(String var1);

        abstract ImmutableSet.Builder<String> propertiesBuilder();

        @JsonProperty(value="properties")
        public Builder properties(Set<String> properties) {
            this.propertiesBuilder().addAll(properties);
            return this;
        }

        @JsonProperty(value="requires")
        public abstract Builder requires(Map<String, PluginMetadataSummary> var1);

        @JsonProperty(value="owner")
        public abstract Builder owner(@Nullable String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        @JsonProperty(value="state")
        public abstract Builder state(Map<String, ViewStateDTO> var1);

        @JsonCreator
        public static Builder create() {
            return new .AutoValue_ViewDTO.Builder().type(Type.DASHBOARD).summary("").description("").properties((Set<String>)ImmutableSet.of()).requires(Collections.emptyMap()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC));
        }

        public abstract ViewDTO build();
    }

    public static enum Type {
        SEARCH,
        DASHBOARD;

    }
}

