/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.lookup.CachePurge;
import org.graylog2.lookup.LookupDataAdapterRefreshService;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.lookup.LookupTable;
import org.graylog2.lookup.LookupTableConfigService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.lookup.events.AdapterSharedStoresUpdated;
import org.graylog2.lookup.events.CachesDeleted;
import org.graylog2.lookup.events.CachesUpdated;
import org.graylog2.lookup.events.DataAdaptersDeleted;
import org.graylog2.lookup.events.DataAdaptersUpdated;
import org.graylog2.lookup.events.LookupTablesDeleted;
import org.graylog2.lookup.events.LookupTablesUpdated;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.system.SystemEntity;
import org.graylog2.utilities.LoggingServiceListener;
import org.graylog2.utilities.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LookupTableService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(LookupTableService.class);
    private final LookupTableConfigService configService;
    private final Map<String, LookupCache.Factory> cacheFactories;
    private final Map<String, LookupDataAdapter.Factory> adapterFactories;
    private final Map<String, LookupDataAdapter.Factory2> adapterFactories2;
    private final Map<String, LookupDataAdapter.Factory2> systemAdapterFactories;
    private final ScheduledExecutorService scheduler;
    private final EventBus eventBus;
    private final LookupDataAdapterRefreshService adapterRefreshService;
    private final ConcurrentMap<String, LookupTable> liveTables = new ConcurrentHashMap<String, LookupTable>();
    private final ConcurrentMap<String, LookupDataAdapter> idToAdapter = new ConcurrentHashMap<String, LookupDataAdapter>();
    private final ConcurrentMap<String, LookupDataAdapter> liveAdapters = new ConcurrentHashMap<String, LookupDataAdapter>();
    private final ConcurrentMap<String, LookupCache> idToCache = new ConcurrentHashMap<String, LookupCache>();
    private final ConcurrentMap<String, LookupCache> liveCaches = new ConcurrentHashMap<String, LookupCache>();

    @Inject
    public LookupTableService(LookupTableConfigService configService, Map<String, LookupCache.Factory> cacheFactories, Map<String, LookupDataAdapter.Factory> adapterFactories, Map<String, LookupDataAdapter.Factory2> adapterFactories2, @SystemEntity Map<String, LookupDataAdapter.Factory2> systemAdapterFactories, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, EventBus eventBus) {
        this.configService = configService;
        this.cacheFactories = cacheFactories;
        this.adapterFactories = adapterFactories;
        this.adapterFactories2 = adapterFactories2;
        this.systemAdapterFactories = systemAdapterFactories;
        this.scheduler = scheduler;
        this.eventBus = eventBus;
        this.adapterRefreshService = new LookupDataAdapterRefreshService(scheduler, this.liveTables);
    }

    protected LookupTableConfigService getConfigService() {
        return this.configService;
    }

    protected ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    protected void startUp() throws Exception {
        this.adapterRefreshService.startAsync().awaitRunning();
        CountDownLatch adaptersLatch = this.createAndStartAdapters();
        CountDownLatch cachesLatch = this.createAndStartCaches();
        adaptersLatch.await();
        cachesLatch.await();
        this.createLookupTables();
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        this.liveTables.clear();
        this.liveCaches.forEach((name, cache) -> {
            cache.addListener(new Service.Listener((LookupCache)((Object)cache), (String)name){
                final /* synthetic */ LookupCache val$cache;
                final /* synthetic */ String val$name;
                {
                    this.val$cache = lookupCache;
                    this.val$name = string;
                }

                public void terminated(Service.State from) {
                    LookupTableService.this.idToCache.remove(this.val$cache.id());
                    LookupTableService.this.liveCaches.remove(this.val$name);
                }
            }, this.scheduler);
            cache.stopAsync();
        });
        this.liveAdapters.forEach((name, adapter) -> {
            adapter.addListener(new Service.Listener((LookupDataAdapter)((Object)adapter), (String)name){
                final /* synthetic */ LookupDataAdapter val$adapter;
                final /* synthetic */ String val$name;
                {
                    this.val$adapter = lookupDataAdapter;
                    this.val$name = string;
                }

                public void terminated(Service.State from) {
                    LookupTableService.this.idToAdapter.remove(this.val$adapter.id());
                    LookupTableService.this.liveAdapters.remove(this.val$name);
                }
            }, this.scheduler);
            adapter.stopAsync();
        });
        this.adapterRefreshService.stopAsync();
    }

    @Subscribe
    public void handleAdapterUpdate(DataAdaptersUpdated updated) {
        this.scheduler.schedule(() -> {
            ImmutableSet.Builder existingAdapters = ImmutableSet.builder();
            Map<DataAdapterDto, LookupDataAdapter> newAdapters = this.createAdapters(this.configService.findDataAdaptersForIds(updated.ids()));
            CountDownLatch runningLatch = new CountDownLatch(newAdapters.size());
            newAdapters.forEach((dto, adapter) -> {
                adapter.addListener(new DataAdapterListener((DataAdapterDto)dto, (LookupDataAdapter)((Object)((Object)adapter)), runningLatch, arg_0 -> ((ImmutableSet.Builder)existingAdapters).add(arg_0)), this.scheduler);
                adapter.startAsync();
            });
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)runningLatch);
            Collection<LookupTableDto> tablesToUpdate = this.configService.findTablesForDataAdapterIds(updated.ids());
            tablesToUpdate.forEach(this::createLookupTable);
            existingAdapters.build().forEach(AbstractIdleService::stopAsync);
        }, 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleAdapterDelete(DataAdaptersDeleted deleted) {
        this.scheduler.schedule(() -> deleted.ids().stream().map(this.idToAdapter::remove).filter(Objects::nonNull).forEach(dataAdapter -> {
            this.liveAdapters.remove(dataAdapter.name());
            dataAdapter.stopAsync();
        }), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleCacheUpdate(CachesUpdated updated) {
        this.scheduler.schedule(() -> {
            ImmutableSet.Builder existingCaches = ImmutableSet.builder();
            Map<CacheDto, LookupCache> newCaches = this.createCaches(this.configService.findCachesForIds(updated.ids()));
            CountDownLatch runningLatch = new CountDownLatch(newCaches.size());
            newCaches.forEach((cacheDto, cache) -> {
                cache.addListener(new CacheListener((CacheDto)cacheDto, (LookupCache)((Object)((Object)cache)), runningLatch, arg_0 -> ((ImmutableSet.Builder)existingCaches).add(arg_0)), this.scheduler);
                cache.startAsync();
            });
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)runningLatch);
            Collection<LookupTableDto> tablesToUpdate = this.configService.findTablesForCacheIds(updated.ids());
            tablesToUpdate.forEach(this::createLookupTable);
            existingCaches.build().forEach(AbstractIdleService::stopAsync);
        }, 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleAdapterSharedStoreUpdate(AdapterSharedStoresUpdated updated) {
        this.scheduler.schedule(() -> updated.ids().stream().forEach(dataAdapterId -> this.liveTables.values().stream().filter(table -> table.dataAdapter().id().equals(dataAdapterId)).map(lookupTable -> new CachePurge(this.liveTables, lookupTable.dataAdapter())).forEach(CachePurge::purgeAll)), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleCacheDelete(CachesDeleted deleted) {
        this.scheduler.schedule(() -> deleted.ids().stream().map(this.idToCache::remove).filter(Objects::nonNull).forEach(lookupCache -> {
            this.liveCaches.remove(lookupCache.name());
            lookupCache.stopAsync();
        }), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleLookupTableUpdate(LookupTablesUpdated updated) {
        this.scheduler.schedule(() -> updated.lookupTableIds().forEach(id -> this.configService.getTable((String)id).map(this::createLookupTable)), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleLookupTableDelete(LookupTablesDeleted deleted) {
        this.scheduler.schedule(() -> deleted.lookupTableNames().forEach(this.liveTables::remove), 0L, TimeUnit.SECONDS);
    }

    protected CountDownLatch createAndStartAdapters() {
        Map<DataAdapterDto, LookupDataAdapter> adapters = this.createAdapters(this.configService.loadAllDataAdapters());
        CountDownLatch latch = new CountDownLatch(Math.toIntExact(adapters.size()));
        adapters.forEach((dto, adapter) -> {
            adapter.addListener(new DataAdapterListener((DataAdapterDto)dto, (LookupDataAdapter)((Object)adapter), latch), this.scheduler);
            adapter.startAsync();
        });
        return latch;
    }

    private Map<DataAdapterDto, LookupDataAdapter> createAdapters(Collection<DataAdapterDto> adapterDtos) {
        return adapterDtos.stream().map(dto -> Maps.immutableEntry((Object)dto, (Object)((Object)this.createAdapter((DataAdapterDto)dto)))).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected LookupDataAdapter createAdapter(DataAdapterDto dto) {
        try {
            Object adapter;
            LookupDataAdapter.Factory2 systemFactory = this.systemAdapterFactories.get(dto.config().type());
            LookupDataAdapter.Factory2 factory2 = this.adapterFactories2.get(dto.config().type());
            LookupDataAdapter.Factory factory = this.adapterFactories.get(dto.config().type());
            if (factory2 != null) {
                adapter = factory2.create(dto);
            } else if (factory != null) {
                adapter = factory.create(dto.id(), dto.name(), dto.config());
            } else if (systemFactory != null) {
                adapter = systemFactory.create(dto);
            } else {
                LOG.warn("Unable to load data adapter {} of type {}, missing a factory. Is a required plugin missing?", (Object)dto.name(), (Object)dto.config().type());
                return null;
            }
            this.addListeners((LookupDataAdapter)((Object)adapter), dto);
            return adapter;
        }
        catch (Exception e) {
            LOG.error("Couldn't create adapter <{}/{}>", new Object[]{dto.name(), dto.id(), e});
            return null;
        }
    }

    protected void addListeners(LookupDataAdapter adapter, DataAdapterDto dto) {
        adapter.addListener(new LoggingServiceListener("Data Adapter", String.format(Locale.ENGLISH, "%s/%s [@%s]", dto.name(), dto.id(), ObjectUtils.objectId((Object)adapter)), LOG), this.scheduler);
        adapter.addListener(this.adapterRefreshService.newServiceListener(adapter), this.scheduler);
    }

    private CountDownLatch createAndStartCaches() {
        Map<CacheDto, LookupCache> caches = this.createCaches(this.configService.loadAllCaches());
        CountDownLatch latch = new CountDownLatch(Math.toIntExact(caches.size()));
        caches.forEach((cacheDto, lookupCache) -> {
            lookupCache.addListener(new CacheListener((CacheDto)cacheDto, (LookupCache)((Object)lookupCache), latch), this.scheduler);
            lookupCache.startAsync();
        });
        return latch;
    }

    private Map<CacheDto, LookupCache> createCaches(Collection<CacheDto> cacheDtos) {
        return cacheDtos.stream().map(dto -> Maps.immutableEntry((Object)dto, (Object)((Object)this.createCache((CacheDto)dto)))).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private LookupCache createCache(CacheDto dto) {
        try {
            LookupCache.Factory factory = this.cacheFactories.get(dto.config().type());
            if (factory == null) {
                LOG.warn("Unable to load cache {} of type {}, missing a factory. Is a required plugin missing?", (Object)dto.name(), (Object)dto.config().type());
                return null;
            }
            Object cache = factory.create(dto.id(), dto.name(), dto.config());
            cache.addListener((Service.Listener)new LoggingServiceListener("Cache", String.format(Locale.ENGLISH, "%s/%s [@%s]", dto.name(), dto.id(), ObjectUtils.objectId(cache)), LOG), (Executor)this.scheduler);
            return cache;
        }
        catch (Exception e) {
            LOG.error("Couldn't create cache <{}/{}>", new Object[]{dto.name(), dto.id(), e});
            return null;
        }
    }

    private void createLookupTables() {
        try {
            this.configService.loadAllTables().forEach(dto -> {
                try {
                    this.createLookupTable((LookupTableDto)dto);
                }
                catch (Exception e) {
                    LOG.error("Couldn't create lookup table <{}/{}>: {}", new Object[]{dto.name(), dto.id(), e.getMessage()});
                }
            });
        }
        catch (Exception e) {
            LOG.error("Couldn't create lookup tables", (Throwable)e);
        }
    }

    private LookupTable createLookupTable(LookupTableDto dto) {
        LookupDefaultMultiValue defaultMultiValue;
        LookupDefaultSingleValue defaultSingleValue;
        LookupCache cache = (LookupCache)((Object)this.idToCache.get(dto.cacheId()));
        if (cache == null) {
            LOG.warn("Lookup table {} is referencing a missing cache {}, check if it started properly.", (Object)dto.name(), (Object)dto.cacheId());
            return null;
        }
        LookupDataAdapter adapter = (LookupDataAdapter)((Object)this.idToAdapter.get(dto.dataAdapterId()));
        if (adapter == null) {
            LOG.warn("Lookup table {} is referencing a missing data adapter {}, check if it started properly.", (Object)dto.name(), (Object)dto.dataAdapterId());
            return null;
        }
        try {
            defaultSingleValue = LookupDefaultSingleValue.create(dto.defaultSingleValue(), dto.defaultSingleValueType());
        }
        catch (Exception e) {
            LOG.error("Could not create default single value object for lookup table {}/{}: {}", new Object[]{dto.name(), dto.id(), e.getMessage()});
            return null;
        }
        try {
            defaultMultiValue = LookupDefaultMultiValue.create(dto.defaultMultiValue(), dto.defaultMultiValueType());
        }
        catch (Exception e) {
            LOG.error("Could not create default multi value object for lookup table {}/{}: {}", new Object[]{dto.name(), dto.id(), e.getMessage()});
            return null;
        }
        LookupTable table = LookupTable.builder().id(dto.id()).name(dto.name()).description(dto.description()).title(dto.title()).cache(cache).dataAdapter(adapter).defaultSingleValue(defaultSingleValue).defaultMultiValue(defaultMultiValue).build();
        LookupCache newCache = table.cache();
        LookupDataAdapter newAdapter = table.dataAdapter();
        LOG.info("Starting lookup table {}/{} [@{}] using cache {}/{} [@{}], data adapter {}/{} [@{}]", new Object[]{table.name(), table.id(), ObjectUtils.objectId(table), newCache.name(), newCache.id(), ObjectUtils.objectId((Object)newCache), newAdapter.name(), newAdapter.id(), ObjectUtils.objectId((Object)newAdapter)});
        LookupTable previous = this.liveTables.put(dto.name(), table);
        if (previous != null) {
            LOG.info("Replaced previous lookup table {} [@{}]", (Object)previous.name(), (Object)ObjectUtils.objectId(previous));
        }
        return table;
    }

    public Optional<CachePurge> newCachePurge(String tableName) {
        LookupTable table = this.getTable(tableName);
        if (table != null) {
            return Optional.of(new CachePurge(this.liveTables, table.dataAdapter()));
        }
        return Optional.empty();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Nullable
    @VisibleForTesting
    public LookupTable getTable(String name) {
        LookupTable lookupTable = (LookupTable)this.liveTables.get(name);
        if (lookupTable == null) {
            LOG.warn("Lookup table <{}> does not exist", (Object)name);
        }
        return lookupTable;
    }

    public boolean hasTable(String name) {
        if (this.liveTables.containsKey(name)) {
            return true;
        }
        try {
            return this.configService.getTable(name).isPresent();
        }
        catch (Exception e) {
            LOG.error("Couldn't load lookup table <{}> from database", (Object)name, (Object)e);
            return false;
        }
    }

    public Collection<LookupDataAdapter> getDataAdapters(Set<String> adapterNames) {
        if (adapterNames == null) {
            return Collections.emptySet();
        }
        return adapterNames.stream().map(this.liveAdapters::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Collection<LookupCache> getCaches(Set<String> cacheNames) {
        if (cacheNames == null) {
            return Collections.emptySet();
        }
        return cacheNames.stream().map(this.liveCaches::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static class Builder {
        private final LookupTableService lookupTableService;
        private String lookupTableName;

        public Builder(LookupTableService lookupTableService) {
            this.lookupTableService = lookupTableService;
        }

        public Builder lookupTable(String name) {
            this.lookupTableName = name;
            return this;
        }

        public Function build() {
            return new Function(this.lookupTableService, this.lookupTableName);
        }
    }

    private class CacheListener
    extends Service.Listener {
        private final CacheDto dto;
        private final LookupCache cache;
        private final CountDownLatch latch;
        private final Consumer<LookupCache> replacedCacheConsumer;

        public CacheListener(CacheDto dto, LookupCache cache, CountDownLatch latch) {
            this(dto, cache, latch, replacedCache -> {});
        }

        public CacheListener(CacheDto dto, LookupCache cache, CountDownLatch latch, Consumer<LookupCache> replacedCacheConsumer) {
            this.dto = dto;
            this.cache = cache;
            this.latch = latch;
            this.replacedCacheConsumer = replacedCacheConsumer;
        }

        public void running() {
            try {
                LookupTableService.this.idToCache.put(this.dto.id(), this.cache);
                LookupCache existing = LookupTableService.this.liveCaches.put(this.dto.name(), this.cache);
                if (existing != null) {
                    this.replacedCacheConsumer.accept(existing);
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public void failed(Service.State from, Throwable failure) {
            try {
                LOG.warn("Unable to start cache {}: {}", (Object)this.dto.name(), (Object)ExceptionUtils.getRootCauseMessage(failure));
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    protected class DataAdapterListener
    extends Service.Listener {
        private final DataAdapterDto dto;
        private final LookupDataAdapter adapter;
        private final CountDownLatch latch;
        private final Consumer<LookupDataAdapter> replacedAdapterConsumer;

        public DataAdapterListener(DataAdapterDto dto, LookupDataAdapter adapter, CountDownLatch latch) {
            this(dto, adapter, latch, replacedAdapter -> {});
        }

        public DataAdapterListener(DataAdapterDto dto, LookupDataAdapter adapter, CountDownLatch latch, Consumer<LookupDataAdapter> replacedAdapterConsumer) {
            this.dto = dto;
            this.adapter = adapter;
            this.latch = latch;
            this.replacedAdapterConsumer = replacedAdapterConsumer;
        }

        public void running() {
            try {
                LookupTableService.this.idToAdapter.put(this.dto.id(), this.adapter);
                LookupDataAdapter existing = LookupTableService.this.liveAdapters.put(this.dto.name(), this.adapter);
                if (existing != null) {
                    this.replacedAdapterConsumer.accept(existing);
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public void failed(Service.State from, Throwable failure) {
            try {
                LOG.warn("Unable to start data adapter {}: {}", (Object)this.dto.name(), (Object)ExceptionUtils.getRootCauseMessage(failure));
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    public static class Function {
        private final LookupTableService lookupTableService;
        private final String lookupTableName;

        public Function(LookupTableService lookupTableService, String lookupTableName) {
            this.lookupTableService = lookupTableService;
            this.lookupTableName = lookupTableName;
        }

        @Nullable
        public LookupResult lookup(@Nonnull Object key) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.withError();
            }
            LookupResult result = lookupTable.lookup(key);
            if (result == null) {
                return LookupResult.empty();
            }
            if (result.hasError()) {
                return result;
            }
            if (result.isEmpty()) {
                return LookupResult.empty();
            }
            return result;
        }

        private Object requireValidKey(Object key) {
            return Objects.requireNonNull(key, "key cannot be null");
        }

        private List<String> requireValidStringList(List<String> values) {
            return Objects.requireNonNull(values, "values cannot be null").stream().filter(Objects::nonNull).filter(v -> !v.isEmpty()).collect(Collectors.toList());
        }

        public LookupResult setValue(Object key, Object value) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.withError();
            }
            return lookupTable.setValue(this.requireValidKey(key), Objects.requireNonNull(value, "value cannot be null"));
        }

        public LookupResult setStringList(Object key, List<String> value) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.withError();
            }
            return lookupTable.setStringList(this.requireValidKey(key), this.requireValidStringList(value));
        }

        public LookupResult addStringList(Object key, List<String> value, boolean keepDuplicates) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.withError();
            }
            return lookupTable.addStringList(this.requireValidKey(key), this.requireValidStringList(value), keepDuplicates);
        }

        public LookupResult removeStringList(Object key, List<String> value) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.withError();
            }
            return lookupTable.removeStringList(this.requireValidKey(key), this.requireValidStringList(value));
        }

        public void clearKey(Object key) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return;
            }
            lookupTable.clearKey(this.requireValidKey(key));
        }

        public LookupTable getTable() {
            return this.lookupTableService.getTable(this.lookupTableName);
        }
    }
}

