/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Collection;
import org.graylog2.indexer.indices.stats.IndexStatistics;
import org.graylog2.rest.models.system.indexer.responses.IndexStats;
import org.graylog2.rest.resources.system.indexer.responses.AutoValue_IndexSetStats;

@JsonAutoDetect
@AutoValue
public abstract class IndexSetStats {
    private static final String FIELD_INDICES = "indices";
    private static final String FIELD_DOCUMENTS = "documents";
    private static final String FIELD_SIZE = "size";

    @JsonProperty(value="indices")
    public abstract long indices();

    @JsonProperty(value="documents")
    public abstract long documents();

    @JsonProperty(value="size")
    public abstract long size();

    @JsonCreator
    public static IndexSetStats create(@JsonProperty(value="indices") long indices, @JsonProperty(value="documents") long documents, @JsonProperty(value="size") long size) {
        return new AutoValue_IndexSetStats(indices, documents, size);
    }

    public static IndexSetStats fromIndexStatistics(Collection<IndexStatistics> indexStatistics, Collection<String> closedIndices) {
        long totalIndicesCount = indexStatistics.size() + closedIndices.size();
        long totalDocumentsCount = indexStatistics.stream().map(IndexStatistics::allShards).map(IndexStats::documents).mapToLong(IndexStats.DocsStats::count).sum();
        long totalSizeInBytes = indexStatistics.stream().map(IndexStatistics::allShards).mapToLong(IndexStats::storeSizeBytes).sum();
        return IndexSetStats.create(totalIndicesCount, totalDocumentsCount, totalSizeInBytes);
    }
}

