/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.headerauth.HTTPHeaderAuthConfig;
import org.graylog2.shared.security.ActorAwareAuthenticationToken;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;
import org.graylog2.shared.security.ShiroRequestHeadersBinder;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.UserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCreator {
    private static final Logger log = LoggerFactory.getLogger(SessionCreator.class);
    private final UserService userService;
    private final AuditEventSender auditEventSender;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public SessionCreator(UserService userService, AuditEventSender auditEventSender, ClusterConfigService clusterConfigService) {
        this.userService = userService;
        this.auditEventSender = auditEventSender;
        this.clusterConfigService = clusterConfigService;
    }

    public Optional<Session> login(@Nullable String currentSessionId, String host, ActorAwareAuthenticationToken authToken) throws AuthenticationServiceUnavailableException {
        String previousSessionId = (String)StringUtils.defaultIfBlank((CharSequence)currentSessionId, null);
        Subject subject = new Subject.Builder().sessionId((Serializable)((Object)previousSessionId)).host(host).buildSubject();
        ThreadContext.bind((Subject)subject);
        try {
            Session session = subject.getSession();
            subject.login((AuthenticationToken)authToken);
            return this.createSession(subject, session, host);
        }
        catch (AuthenticationServiceUnavailableException e) {
            log.info("Session creation failed due to authentication service being unavailable. Actor: \"{}\"", (Object)authToken.getActor().urn());
            ImmutableMap auditEventContext = ImmutableMap.of((Object)"remote_address", (Object)host, (Object)"message", (Object)("Authentication service unavailable: " + e.getMessage()));
            this.auditEventSender.failure(authToken.getActor(), "server:session:create", (Map<String, Object>)auditEventContext);
            throw e;
        }
        catch (AuthenticationException e) {
            log.info("Invalid credentials in session create request. Actor: \"{}\"", (Object)authToken.getActor().urn());
            ImmutableMap auditEventContext = ImmutableMap.of((Object)"remote_address", (Object)host);
            this.auditEventSender.failure(authToken.getActor(), "server:session:create", (Map<String, Object>)auditEventContext);
            return Optional.empty();
        }
    }

    public Optional<Session> create(Subject subject, String host) {
        ThreadContext.bind((Subject)subject);
        Session session = subject.getSession();
        HTTPHeaderAuthConfig httpHeaderConfig = this.loadHTTPHeaderConfig();
        Optional<String> usernameHeader = ShiroRequestHeadersBinder.getHeaderFromThreadContext(httpHeaderConfig.usernameHeader());
        if (httpHeaderConfig.enabled() && usernameHeader.isPresent()) {
            session.setAttribute((Object)"http-header-auth-user", (Object)usernameHeader.get());
        }
        return this.createSession(subject, session, host);
    }

    private Optional<Session> createSession(Subject subject, Session session, String host) {
        String userId = subject.getPrincipal().toString();
        User user = this.userService.loadById(userId);
        if (user != null) {
            long timeoutInMillis = user.getSessionTimeoutMs();
            session.setTimeout(timeoutInMillis);
            session.setAttribute((Object)"username", (Object)user.getName());
            this.getSessionAttributes(subject).forEach((arg_0, arg_1) -> ((Session)session).setAttribute(arg_0, arg_1));
        } else {
            session.setTimeout(UserImpl.DEFAULT_SESSION_TIMEOUT_MS);
        }
        session.touch();
        ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSubjectDAO().save(subject);
        ImmutableMap auditEventContext = ImmutableMap.of((Object)"session_id", (Object)session.getId(), (Object)"remote_address", (Object)host);
        this.auditEventSender.success(AuditActor.user(user.getName()), "server:session:create", (Map<String, Object>)auditEventContext);
        return Optional.of(session);
    }

    private Map<?, ?> getSessionAttributes(Subject subject) {
        List principals = subject.getPrincipals().asList();
        if (principals.size() < 2) {
            return Collections.emptyMap();
        }
        Object sessionAttributes = principals.get(1);
        if (sessionAttributes instanceof Map) {
            return (Map)sessionAttributes;
        }
        log.error("Unable to extract session attributes from subject. Expected <Map.class> but got <{}>.", (Object)sessionAttributes.getClass().getSimpleName());
        return Collections.emptyMap();
    }

    private HTTPHeaderAuthConfig loadHTTPHeaderConfig() {
        return this.clusterConfigService.getOrDefault(HTTPHeaderAuthConfig.class, HTTPHeaderAuthConfig.createDisabled());
    }
}

