/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.elasticsearch.AutoValue_ElasticsearchQueryString;
import org.graylog.plugins.views.search.engine.BackendQuery;

@JsonAutoDetect
@JsonTypeName(value="elasticsearch")
@AutoValue
public abstract class ElasticsearchQueryString
implements BackendQuery {
    public static final String NAME = "elasticsearch";

    public static ElasticsearchQueryString empty() {
        return ElasticsearchQueryString.of("");
    }

    @JsonCreator
    public static ElasticsearchQueryString of(String query) {
        return new AutoValue_ElasticsearchQueryString(NAME, query);
    }

    @JsonCreator
    public static ElasticsearchQueryString create(@JsonProperty(value="type") String type, @JsonProperty(value="query_string") String query) {
        return new AutoValue_ElasticsearchQueryString(type, query);
    }

    @Override
    @Nullable
    public abstract String type();

    @Override
    @JsonProperty
    public abstract String queryString();

    @JsonIgnore
    public boolean isEmpty() {
        String trimmed = this.queryString().trim();
        return trimmed.equals("") || trimmed.equals("*");
    }

    public ElasticsearchQueryString concatenate(ElasticsearchQueryString other) {
        String thisQueryString = Strings.nullToEmpty((String)this.queryString()).trim();
        String otherQueryString = Strings.nullToEmpty((String)other.queryString()).trim();
        if (!thisQueryString.isEmpty() && !otherQueryString.isEmpty()) {
            return ElasticsearchQueryString.of("(" + thisQueryString + ") AND (" + otherQueryString + ")");
        }
        return this.queryString().isEmpty() ? other : this;
    }

    public String toString() {
        return this.type() + ": " + this.queryString();
    }
}

