/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchfilters.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.searchfilters.model.InlineQueryStringSearchFilter;

final class AutoValue_InlineQueryStringSearchFilter
extends InlineQueryStringSearchFilter {
    private final String title;
    private final String description;
    private final String queryString;
    private final boolean negation;
    private final boolean disabled;

    private AutoValue_InlineQueryStringSearchFilter(@Nullable String title, @Nullable String description, String queryString, boolean negation, boolean disabled) {
        this.title = title;
        this.description = description;
        this.queryString = queryString;
        this.negation = negation;
        this.disabled = disabled;
    }

    @Override
    @JsonProperty(value="title")
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="queryString")
    public String queryString() {
        return this.queryString;
    }

    @Override
    @JsonProperty(value="negation", defaultValue="false")
    public boolean negation() {
        return this.negation;
    }

    @Override
    @JsonProperty(value="disabled", defaultValue="false")
    public boolean disabled() {
        return this.disabled;
    }

    public String toString() {
        return "InlineQueryStringSearchFilter{title=" + this.title + ", description=" + this.description + ", queryString=" + this.queryString + ", negation=" + this.negation + ", disabled=" + this.disabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InlineQueryStringSearchFilter) {
            InlineQueryStringSearchFilter that = (InlineQueryStringSearchFilter)o;
            return (this.title == null ? that.title() == null : this.title.equals(that.title())) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.queryString.equals(that.queryString()) && this.negation == that.negation() && this.disabled == that.disabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.title == null ? 0 : this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryString.hashCode();
        h$ *= 1000003;
        h$ ^= this.negation ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.disabled ? 1231 : 1237;
    }

    @Override
    public InlineQueryStringSearchFilter.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends InlineQueryStringSearchFilter.Builder {
        private String title;
        private String description;
        private String queryString;
        private Boolean negation;
        private Boolean disabled;

        Builder() {
        }

        private Builder(InlineQueryStringSearchFilter source) {
            this.title = source.title();
            this.description = source.description();
            this.queryString = source.queryString();
            this.negation = source.negation();
            this.disabled = source.disabled();
        }

        @Override
        public InlineQueryStringSearchFilter.Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder queryString(String queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder negation(boolean negation) {
            this.negation = negation;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter.Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public InlineQueryStringSearchFilter build() {
            Object missing = "";
            if (this.queryString == null) {
                missing = (String)missing + " queryString";
            }
            if (this.negation == null) {
                missing = (String)missing + " negation";
            }
            if (this.disabled == null) {
                missing = (String)missing + " disabled";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_InlineQueryStringSearchFilter(this.title, this.description, this.queryString, this.negation, this.disabled);
        }
    }
}

