/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.health;

import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NodeRole {
    COORDINATING_ONLY(45, false),
    DATA(100, true),
    DATA_COLD(99, true),
    DATA_CONTENT(115, true),
    DATA_HOT(104, true),
    DATA_WARM(119, true),
    FROZEN(102, true),
    INGEST(105, false),
    MACHINE_LEARNING(108, false),
    MASTER_ELIGIBLE(109, false),
    REMOTE_CLUSTER_CLIENT(114, false),
    TRANSFORM(116, false),
    VOTING_ONLY(118, false);

    private static final Logger log;
    private final int symbol;
    private final boolean holdsData;
    private static final Map<Integer, NodeRole> symbolToRole;

    private NodeRole(int symbol, boolean holdsData) {
        this.symbol = symbol;
        this.holdsData = holdsData;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public boolean holdsData() {
        return this.holdsData;
    }

    public static EnumSet<NodeRole> parseSymbolString(String symbols) {
        EnumSet roles = symbols.chars().boxed().map(symbol -> {
            NodeRole role = symbolToRole.get(symbol);
            if (role == null) {
                log.warn("Unknown ES node role <{}>.", (Object)Character.valueOf((char)symbol.intValue()));
            }
            return role;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(NodeRole.class)));
        log.debug("Parsed node roles <{}> out of symbol string <{}>.", (Object)roles, (Object)symbols);
        return roles;
    }

    static {
        log = LoggerFactory.getLogger(NodeRole.class);
        symbolToRole = Stream.of(NodeRole.values()).collect(Collectors.toMap(NodeRole::getSymbol, r -> r));
    }
}

