/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.graylog2.inputs.Input;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.shared.inputs.InputDescription;
import org.graylog2.shared.rest.resources.RestResource;

public class AbstractInputsResource
extends RestResource {
    private final Map<String, InputDescription> availableInputs;

    public AbstractInputsResource(Map<String, InputDescription> availableInputs) {
        this.availableInputs = availableInputs;
    }

    protected InputSummary getInputSummary(Input input) {
        InputDescription inputDescription = this.availableInputs.get(input.getType());
        Object name = inputDescription != null ? inputDescription.getName() : "Unknown Input (" + input.getType() + ")";
        ConfigurationRequest configurationRequest = inputDescription != null ? inputDescription.getConfigurationRequest() : null;
        Map<String, Object> configuration = this.isPermitted("inputs:edit", input.getId()) ? input.getConfiguration() : this.maskPasswordsInConfiguration(input.getConfiguration(), configurationRequest);
        return InputSummary.create(input.getTitle(), input.isGlobal(), (String)name, input.getContentPack(), input.getId(), input.getCreatedAt(), input.getType(), input.getCreatorUserId(), configuration, input.getStaticFields(), input.getNodeId());
    }

    protected Map<String, Object> maskPasswordsInConfiguration(Map<String, Object> configuration, ConfigurationRequest configurationRequest) {
        if (configuration == null || configurationRequest == null) {
            return configuration;
        }
        return configuration.entrySet().stream().collect(HashMap::new, (map, entry) -> {
            ConfigurationField field = configurationRequest.getField((String)entry.getKey());
            if (field instanceof TextField && !Strings.isNullOrEmpty((String)((String)entry.getValue()))) {
                if (AbstractInputsResource.isPassword(field)) {
                    map.put((String)entry.getKey(), "<password set>");
                    return;
                }
                if (AbstractInputsResource.isSensitive(field)) {
                    map.put((String)entry.getKey(), "<value hidden>");
                    return;
                }
            }
            map.put((String)entry.getKey(), entry.getValue());
        }, HashMap::putAll);
    }

    private static boolean isPassword(ConfigurationField field) {
        return field.getAttributes().contains(TextField.Attribute.IS_PASSWORD.toString().toLowerCase(Locale.ENGLISH));
    }

    private static boolean isSensitive(ConfigurationField field) {
        return field.getAttributes().contains(TextField.Attribute.IS_SENSITIVE.toString().toLowerCase(Locale.ENGLISH));
    }
}

