/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNTypes;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.MongoDbAuthorizationCacheManager;
import org.graylog2.shared.security.ShiroRequestHeadersBinder;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.events.UserChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbAuthorizationRealm
extends AuthorizingRealm {
    public static final String NAME = "mongodb-authorization-realm";
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbAuthorizationRealm.class);
    private final UserService userService;
    private final PermissionAndRoleResolver permissionAndRoleResolver;
    private final GRNRegistry grnRegistry;

    @Inject
    MongoDbAuthorizationRealm(UserService userService, MongoDbAuthorizationCacheManager mongoDbAuthorizationCacheManager, PermissionAndRoleResolver permissionAndRoleResolver, GRNRegistry grnRegistry, EventBus serverEventBus) {
        this.userService = userService;
        this.permissionAndRoleResolver = permissionAndRoleResolver;
        this.grnRegistry = grnRegistry;
        this.setCachingEnabled(true);
        this.setCacheManager(mongoDbAuthorizationCacheManager);
        serverEventBus.register((Object)this);
        this.setPermissionResolver((PermissionResolver)new WildcardPermissionResolver(true));
    }

    protected Object getAuthorizationCacheKey(PrincipalCollection principals) {
        Optional<String> requestId = ShiroRequestHeadersBinder.getHeaderFromThreadContext("X-Request-Id");
        if (requestId.isPresent()) {
            return ImmutableSet.builder().addAll((Iterable)principals).add((Object)requestId.get()).build();
        }
        LOG.warn("Could not find X-Request-Id header. This is not supposed to happen.");
        return principals.asSet();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LOG.debug("Retrieving authorization information for: {}", (Object)principals);
        GRN principal = this.getUserPrincipal(principals).orElseGet(() -> this.getGRNPrincipal(principals).orElse(null));
        if (principal == null) {
            return new SimpleAuthorizationInfo();
        }
        LOG.debug("GRN principal: {}", (Object)principal);
        ImmutableSet.Builder permissionsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder rolesBuilder = ImmutableSet.builder();
        permissionsBuilder.addAll(this.permissionAndRoleResolver.resolvePermissionsForPrincipal(principal));
        rolesBuilder.addAll(this.permissionAndRoleResolver.resolveRolesForPrincipal(principal));
        if (GRNTypes.USER.equals(principal.grnType())) {
            User user = this.userService.loadById(principal.entity());
            if (user != null) {
                Set<Permission> userPermissions = user.getObjectPermissions();
                permissionsBuilder.addAll(userPermissions);
                rolesBuilder.addAll(user.getRoleIds());
            } else {
                LOG.warn("User <{}> not found for permission and role resolving", (Object)principal);
            }
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.setObjectPermissions((Set)permissionsBuilder.build());
        info.setRoles((Set)rolesBuilder.build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authorization info for {} - permissions: {}", (Object)principal, (Object)info.getObjectPermissions());
            LOG.debug("Authorization info for {} - roles: {}", (Object)principal, (Object)info.getRoles());
        }
        return info;
    }

    private Optional<GRN> getUserPrincipal(PrincipalCollection principals) {
        String userId = (String)Iterables.getFirst((Iterable)principals.byType(String.class), null);
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Optional.empty();
        }
        return Optional.of(this.grnRegistry.newGRN("user", userId));
    }

    private Optional<GRN> getGRNPrincipal(PrincipalCollection principals) {
        GRN principal = (GRN)Iterables.getFirst((Iterable)principals.byType(GRN.class), null);
        if (principal == null) {
            return Optional.empty();
        }
        return Optional.of(principal);
    }

    public boolean supports(AuthenticationToken token) {
        return false;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return null;
    }

    @Subscribe
    public void handleUserSave(UserChangedEvent event) {
        this.getAuthorizationCache().clear();
    }
}

