/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import com.google.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;

public class LookupStringListContains
extends AbstractFunction<Boolean> {
    public static final String NAME = "lookup_string_list_contains";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to lookup the given key").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to lookup in the table").build();
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("The value to lookup in the list referenced by the key").build();

    @Inject
    public LookupStringListContains(LookupTableService lookupTableService) {
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        Object value = this.valueParam.required(args, context);
        if (value == null) {
            return false;
        }
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return false;
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return false;
        }
        LookupResult result = table.lookup(key);
        if (result == null || result.isEmpty()) {
            return false;
        }
        return result.stringListValue().contains(value);
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Looks up a value in the string list referenced by the key in the named lookup table.").params(this.lookupTableParam, this.keyParam, this.valueParam).returnType(Boolean.class).build();
    }
}

