/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.errors;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.errors.ResultWindowLimitError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog2.indexer.ElasticsearchException;

public class SearchTypeErrorParser {
    private static final int MAX_DEPTH_OF_EXCEPTION_CAUSE_ANALYSIS = 10;

    public static SearchTypeError parse(Query query, String searchTypeId, ElasticsearchException ex) {
        Throwable possibleResultWindowException = ex;
        for (int attempt = 0; possibleResultWindowException != null && attempt < 10; possibleResultWindowException = possibleResultWindowException.getCause(), ++attempt) {
            Integer resultWindowLimit = SearchTypeErrorParser.parseResultLimit(possibleResultWindowException);
            if (resultWindowLimit == null) continue;
            return new ResultWindowLimitError(query, searchTypeId, resultWindowLimit);
        }
        return new SearchTypeError(query, searchTypeId, ex);
    }

    private static Integer parseResultLimit(Throwable throwable) {
        return SearchTypeErrorParser.parseResultLimit(throwable.getMessage());
    }

    private static Integer parseResultLimit(String description) {
        Matcher matcher;
        if (description.toLowerCase(Locale.US).contains("result window is too large") && (matcher = Pattern.compile("[0-9]+").matcher(description)).find()) {
            return Integer.parseInt(matcher.group(0));
        }
        return null;
    }
}

