/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.AutoValue_QueryDTO;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class QueryDTO {
    @JsonProperty
    public abstract Optional<String> id();

    @JsonProperty
    public abstract Optional<TimeRange> timerange();

    @JsonProperty
    public abstract Optional<Filter> filter();

    @JsonProperty
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty
    public abstract Optional<BackendQuery> query();

    @Nonnull
    @JsonProperty(value="search_types")
    public abstract Set<SearchType> searchTypes();

    static QueryDTO fromQuery(Query query) {
        return Builder.create().id(query.id()).query(query.query()).filter(query.filter()).filters(query.filters()).searchTypes((Set<SearchType>)query.searchTypes()).timerange(query.timerange()).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    Query toQuery() {
        Query.Builder queryBuilder = Query.builder();
        queryBuilder = this.id().map(queryBuilder::id).orElse(queryBuilder);
        queryBuilder = this.timerange().map(queryBuilder::timerange).orElse(queryBuilder);
        queryBuilder = this.filter().map(queryBuilder::filter).orElse(queryBuilder);
        queryBuilder = this.query().map(queryBuilder::query).orElse(queryBuilder);
        return queryBuilder.searchTypes((Set<SearchType>)ImmutableSet.copyOf(this.searchTypes())).filters(this.filters()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder timerange(@Nullable TimeRange var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @JsonProperty(value="search_types")
        public abstract Builder searchTypes(@Nonnull Set<SearchType> var1);

        public abstract QueryDTO build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_QueryDTO.Builder().filters(Collections.emptyList());
        }
    }
}

