/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.graylog.security.certutil.KeyPair;

public class CertRequest {
    private final String cnName;
    private final List<String> subjectAlternativeNames = new ArrayList<String>();
    private final KeyPair issuer;
    private boolean isCA = false;
    private Duration validity;

    public static CertRequest selfSigned(String cnName) {
        return new CertRequest(cnName, null);
    }

    public static CertRequest signed(String cnName, KeyPair issuer) {
        return new CertRequest(cnName, issuer);
    }

    private CertRequest(String cnName, KeyPair issuer) {
        this.cnName = cnName;
        this.issuer = issuer;
    }

    public CertRequest isCA(boolean isCA) {
        this.isCA = isCA;
        return this;
    }

    public CertRequest withSubjectAlternativeName(String name) {
        this.subjectAlternativeNames.add(name);
        return this;
    }

    public String cnName() {
        return this.cnName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public KeyPair issuer() {
        return this.issuer;
    }

    public boolean isCA() {
        return this.isCA;
    }

    public CertRequest validity(Duration certificateValidity) {
        this.validity = certificateValidity;
        return this;
    }

    public Duration validity() {
        return this.validity;
    }
}

